// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AppConsentRequest;
import com.microsoft.graph.models.ConsentRequestFilterByCurrentUserOptions;
import com.microsoft.graph.requests.UserConsentRequestCollectionRequestBuilder;
import com.microsoft.graph.requests.UserConsentRequestRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the App Consent Request Request.
 */
public class AppConsentRequestRequest extends BaseRequest<AppConsentRequest> {
	
    /**
     * The request for the AppConsentRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AppConsentRequestRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AppConsentRequest.class);
    }

    /**
     * Gets the AppConsentRequest from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AppConsentRequest> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AppConsentRequest from the service
     *
     * @return the AppConsentRequest from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AppConsentRequest get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AppConsentRequest> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AppConsentRequest delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AppConsentRequest with a source
     *
     * @param sourceAppConsentRequest the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AppConsentRequest> patchAsync(@Nonnull final AppConsentRequest sourceAppConsentRequest) {
        return sendAsync(HttpMethod.PATCH, sourceAppConsentRequest);
    }

    /**
     * Patches this AppConsentRequest with a source
     *
     * @param sourceAppConsentRequest the source object with updates
     * @return the updated AppConsentRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AppConsentRequest patch(@Nonnull final AppConsentRequest sourceAppConsentRequest) throws ClientException {
        return send(HttpMethod.PATCH, sourceAppConsentRequest);
    }

    /**
     * Creates a AppConsentRequest with a new object
     *
     * @param newAppConsentRequest the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AppConsentRequest> postAsync(@Nonnull final AppConsentRequest newAppConsentRequest) {
        return sendAsync(HttpMethod.POST, newAppConsentRequest);
    }

    /**
     * Creates a AppConsentRequest with a new object
     *
     * @param newAppConsentRequest the new object to create
     * @return the created AppConsentRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AppConsentRequest post(@Nonnull final AppConsentRequest newAppConsentRequest) throws ClientException {
        return send(HttpMethod.POST, newAppConsentRequest);
    }

    /**
     * Creates a AppConsentRequest with a new object
     *
     * @param newAppConsentRequest the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AppConsentRequest> putAsync(@Nonnull final AppConsentRequest newAppConsentRequest) {
        return sendAsync(HttpMethod.PUT, newAppConsentRequest);
    }

    /**
     * Creates a AppConsentRequest with a new object
     *
     * @param newAppConsentRequest the object to create/update
     * @return the created AppConsentRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AppConsentRequest put(@Nonnull final AppConsentRequest newAppConsentRequest) throws ClientException {
        return send(HttpMethod.PUT, newAppConsentRequest);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AppConsentRequestRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AppConsentRequestRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

