// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.IdentityProviderBase;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Identity Provider Base Request.
 */
public class IdentityProviderBaseRequest extends BaseRequest<IdentityProviderBase> {
	
    /**
     * The request for the IdentityProviderBase
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public IdentityProviderBaseRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends IdentityProviderBase> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the IdentityProviderBase
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public IdentityProviderBaseRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, IdentityProviderBase.class);
    }

    /**
     * Gets the IdentityProviderBase from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityProviderBase> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the IdentityProviderBase from the service
     *
     * @return the IdentityProviderBase from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IdentityProviderBase get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityProviderBase> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public IdentityProviderBase delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this IdentityProviderBase with a source
     *
     * @param sourceIdentityProviderBase the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityProviderBase> patchAsync(@Nonnull final IdentityProviderBase sourceIdentityProviderBase) {
        return sendAsync(HttpMethod.PATCH, sourceIdentityProviderBase);
    }

    /**
     * Patches this IdentityProviderBase with a source
     *
     * @param sourceIdentityProviderBase the source object with updates
     * @return the updated IdentityProviderBase
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IdentityProviderBase patch(@Nonnull final IdentityProviderBase sourceIdentityProviderBase) throws ClientException {
        return send(HttpMethod.PATCH, sourceIdentityProviderBase);
    }

    /**
     * Creates a IdentityProviderBase with a new object
     *
     * @param newIdentityProviderBase the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityProviderBase> postAsync(@Nonnull final IdentityProviderBase newIdentityProviderBase) {
        return sendAsync(HttpMethod.POST, newIdentityProviderBase);
    }

    /**
     * Creates a IdentityProviderBase with a new object
     *
     * @param newIdentityProviderBase the new object to create
     * @return the created IdentityProviderBase
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IdentityProviderBase post(@Nonnull final IdentityProviderBase newIdentityProviderBase) throws ClientException {
        return send(HttpMethod.POST, newIdentityProviderBase);
    }

    /**
     * Creates a IdentityProviderBase with a new object
     *
     * @param newIdentityProviderBase the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityProviderBase> putAsync(@Nonnull final IdentityProviderBase newIdentityProviderBase) {
        return sendAsync(HttpMethod.PUT, newIdentityProviderBase);
    }

    /**
     * Creates a IdentityProviderBase with a new object
     *
     * @param newIdentityProviderBase the object to create/update
     * @return the created IdentityProviderBase
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IdentityProviderBase put(@Nonnull final IdentityProviderBase newIdentityProviderBase) throws ClientException {
        return send(HttpMethod.PUT, newIdentityProviderBase);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public IdentityProviderBaseRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public IdentityProviderBaseRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

