// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Delta Parameter Set.
 */
public class WorkbookFunctionsDeltaParameterSet {
    /**
     * The number1.
     * 
     */
    @SerializedName(value = "number1", alternate = {"Number1"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement number1;

    /**
     * The number2.
     * 
     */
    @SerializedName(value = "number2", alternate = {"Number2"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement number2;


    /**
     * Instiaciates a new WorkbookFunctionsDeltaParameterSet
     */
    public WorkbookFunctionsDeltaParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsDeltaParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsDeltaParameterSet(@Nonnull final WorkbookFunctionsDeltaParameterSetBuilder builder) {
        this.number1 = builder.number1;
        this.number2 = builder.number2;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsDeltaParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsDeltaParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsDeltaParameterSet
     */
    public static final class WorkbookFunctionsDeltaParameterSetBuilder {
        /**
         * The number1 parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement number1;
        /**
         * Sets the Number1
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsDeltaParameterSetBuilder withNumber1(@Nullable final com.google.gson.JsonElement val) {
            this.number1 = val;
            return this;
        }
        /**
         * The number2 parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement number2;
        /**
         * Sets the Number2
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsDeltaParameterSetBuilder withNumber2(@Nullable final com.google.gson.JsonElement val) {
            this.number2 = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsDeltaParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsDeltaParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsDeltaParameterSet build() {
            return new WorkbookFunctionsDeltaParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.number1 != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("number1", number1));
        }
        if(this.number2 != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("number2", number2));
        }
        return result;
    }
}
