// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.CountryLookupMethodType;
import com.microsoft.graph.models.NamedLocation;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Country Named Location.
 */
public class CountryNamedLocation extends NamedLocation implements IJsonBackedObject {


    /**
     * The Countries And Regions.
     * List of countries and/or regions in two-letter format specified by ISO 3166-2.
     */
    @SerializedName(value = "countriesAndRegions", alternate = {"CountriesAndRegions"})
    @Expose
	@Nullable
    public java.util.List<String> countriesAndRegions;

    /**
     * The Country Lookup Method.
     * Determines what method is used to decide which country the user is located in. Possible values are clientIpAddress (default) and authenticatorAppGps. Note: authenticatorAppGps is not yet supported in the Microsoft Cloud for US Government.
     */
    @SerializedName(value = "countryLookupMethod", alternate = {"CountryLookupMethod"})
    @Expose
	@Nullable
    public CountryLookupMethodType countryLookupMethod;

    /**
     * The Include Unknown Countries And Regions.
     * true if IP addresses that don't map to a country or region should be included in the named location. Optional. Default value is false.
     */
    @SerializedName(value = "includeUnknownCountriesAndRegions", alternate = {"IncludeUnknownCountriesAndRegions"})
    @Expose
	@Nullable
    public Boolean includeUnknownCountriesAndRegions;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
