// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.ConditionalAccessConditionSet;
import com.microsoft.graph.models.ConditionalAccessGrantControls;
import com.microsoft.graph.models.ConditionalAccessSessionControls;
import com.microsoft.graph.models.ConditionalAccessPolicyState;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Conditional Access Policy.
 */
public class ConditionalAccessPolicy extends Entity implements IJsonBackedObject {


    /**
     * The Conditions.
     * Specifies the rules that must be met for the policy to apply. Required.
     */
    @SerializedName(value = "conditions", alternate = {"Conditions"})
    @Expose
	@Nullable
    public ConditionalAccessConditionSet conditions;

    /**
     * The Created Date Time.
     * The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z. Readonly.
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime createdDateTime;

    /**
     * The Description.
     * Not used.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Display Name.
     * Specifies a display name for the conditionalAccessPolicy object.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Grant Controls.
     * Specifies the grant controls that must be fulfilled to pass the policy.
     */
    @SerializedName(value = "grantControls", alternate = {"GrantControls"})
    @Expose
	@Nullable
    public ConditionalAccessGrantControls grantControls;

    /**
     * The Modified Date Time.
     * The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z. Readonly.
     */
    @SerializedName(value = "modifiedDateTime", alternate = {"ModifiedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime modifiedDateTime;

    /**
     * The Session Controls.
     * Specifies the session controls that are enforced after sign-in.
     */
    @SerializedName(value = "sessionControls", alternate = {"SessionControls"})
    @Expose
	@Nullable
    public ConditionalAccessSessionControls sessionControls;

    /**
     * The State.
     * Specifies the state of the conditionalAccessPolicy object. Possible values are: enabled, disabled, enabledForReportingButNotEnforced. Required.
     */
    @SerializedName(value = "state", alternate = {"State"})
    @Expose
	@Nullable
    public ConditionalAccessPolicyState state;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
