// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.DateTimeTimeZone;
import com.microsoft.graph.models.ScheduleInformation;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Calendar Get Schedule Parameter Set.
 */
public class CalendarGetScheduleParameterSet {
    /**
     * The schedules.
     * 
     */
    @SerializedName(value = "schedules", alternate = {"Schedules"})
    @Expose
	@Nullable
    public java.util.List<String> schedules;

    /**
     * The end Time.
     * 
     */
    @SerializedName(value = "endTime", alternate = {"EndTime"})
    @Expose
	@Nullable
    public DateTimeTimeZone endTime;

    /**
     * The start Time.
     * 
     */
    @SerializedName(value = "startTime", alternate = {"StartTime"})
    @Expose
	@Nullable
    public DateTimeTimeZone startTime;

    /**
     * The availability View Interval.
     * 
     */
    @SerializedName(value = "availabilityViewInterval", alternate = {"AvailabilityViewInterval"})
    @Expose
	@Nullable
    public Integer availabilityViewInterval;


    /**
     * Instiaciates a new CalendarGetScheduleParameterSet
     */
    public CalendarGetScheduleParameterSet() {}
    /**
     * Instiaciates a new CalendarGetScheduleParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected CalendarGetScheduleParameterSet(@Nonnull final CalendarGetScheduleParameterSetBuilder builder) {
        this.schedules = builder.schedules;
        this.endTime = builder.endTime;
        this.startTime = builder.startTime;
        this.availabilityViewInterval = builder.availabilityViewInterval;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static CalendarGetScheduleParameterSetBuilder newBuilder() {
        return new CalendarGetScheduleParameterSetBuilder();
    }
    /**
     * Fluent builder for the CalendarGetScheduleParameterSet
     */
    public static final class CalendarGetScheduleParameterSetBuilder {
        /**
         * The schedules parameter value
         */
        @Nullable
        protected java.util.List<String> schedules;
        /**
         * Sets the Schedules
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public CalendarGetScheduleParameterSetBuilder withSchedules(@Nullable final java.util.List<String> val) {
            this.schedules = val;
            return this;
        }
        /**
         * The endTime parameter value
         */
        @Nullable
        protected DateTimeTimeZone endTime;
        /**
         * Sets the EndTime
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public CalendarGetScheduleParameterSetBuilder withEndTime(@Nullable final DateTimeTimeZone val) {
            this.endTime = val;
            return this;
        }
        /**
         * The startTime parameter value
         */
        @Nullable
        protected DateTimeTimeZone startTime;
        /**
         * Sets the StartTime
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public CalendarGetScheduleParameterSetBuilder withStartTime(@Nullable final DateTimeTimeZone val) {
            this.startTime = val;
            return this;
        }
        /**
         * The availabilityViewInterval parameter value
         */
        @Nullable
        protected Integer availabilityViewInterval;
        /**
         * Sets the AvailabilityViewInterval
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public CalendarGetScheduleParameterSetBuilder withAvailabilityViewInterval(@Nullable final Integer val) {
            this.availabilityViewInterval = val;
            return this;
        }
        /**
         * Instanciates a new CalendarGetScheduleParameterSetBuilder
         */
        @Nullable
        protected CalendarGetScheduleParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public CalendarGetScheduleParameterSet build() {
            return new CalendarGetScheduleParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.schedules != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("schedules", schedules));
        }
        if(this.endTime != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("endTime", endTime));
        }
        if(this.startTime != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("startTime", startTime));
        }
        if(this.availabilityViewInterval != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("availabilityViewInterval", availabilityViewInterval));
        }
        return result;
    }
}
