/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.ChatMessage;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.ChatMessageCollectionPage;
import com.microsoft.graph.requests.ChatMessageCollectionRequestBuilder;
import com.microsoft.graph.requests.ChatMessageCollectionResponse;
import com.microsoft.graph.requests.ChatMessageRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ChatMessageCollectionRequest
extends BaseEntityCollectionRequest<ChatMessage, ChatMessageCollectionResponse, ChatMessageCollectionPage> {
    public ChatMessageCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ChatMessageCollectionResponse.class, ChatMessageCollectionPage.class, ChatMessageCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<ChatMessage> postAsync(@Nonnull ChatMessage newChatMessage) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ChatMessageRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newChatMessage);
    }

    @Nonnull
    public ChatMessage post(@Nonnull ChatMessage newChatMessage) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ChatMessageRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newChatMessage);
    }

    @Nonnull
    public ChatMessageCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public ChatMessageCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public ChatMessageCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public ChatMessageCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ChatMessageCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public ChatMessageCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public ChatMessageCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public ChatMessageCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public ChatMessageCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

