// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.EnrollmentState;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows Autopilot Device Identity.
 */
public class WindowsAutopilotDeviceIdentity extends Entity implements IJsonBackedObject {


    /**
     * The Addressable User Name.
     * Addressable user name.
     */
    @SerializedName(value = "addressableUserName", alternate = {"AddressableUserName"})
    @Expose
	@Nullable
    public String addressableUserName;

    /**
     * The Azure Active Directory Device Id.
     * AAD Device ID - to be deprecated
     */
    @SerializedName(value = "azureActiveDirectoryDeviceId", alternate = {"AzureActiveDirectoryDeviceId"})
    @Expose
	@Nullable
    public String azureActiveDirectoryDeviceId;

    /**
     * The Display Name.
     * Display Name
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Enrollment State.
     * Intune enrollment state of the Windows autopilot device. Possible values are: unknown, enrolled, pendingReset, failed, notContacted, blocked.
     */
    @SerializedName(value = "enrollmentState", alternate = {"EnrollmentState"})
    @Expose
	@Nullable
    public EnrollmentState enrollmentState;

    /**
     * The Group Tag.
     * Group Tag of the Windows autopilot device.
     */
    @SerializedName(value = "groupTag", alternate = {"GroupTag"})
    @Expose
	@Nullable
    public String groupTag;

    /**
     * The Last Contacted Date Time.
     * Intune Last Contacted Date Time of the Windows autopilot device.
     */
    @SerializedName(value = "lastContactedDateTime", alternate = {"LastContactedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastContactedDateTime;

    /**
     * The Managed Device Id.
     * Managed Device ID
     */
    @SerializedName(value = "managedDeviceId", alternate = {"ManagedDeviceId"})
    @Expose
	@Nullable
    public String managedDeviceId;

    /**
     * The Manufacturer.
     * Oem manufacturer of the Windows autopilot device.
     */
    @SerializedName(value = "manufacturer", alternate = {"Manufacturer"})
    @Expose
	@Nullable
    public String manufacturer;

    /**
     * The Model.
     * Model name of the Windows autopilot device.
     */
    @SerializedName(value = "model", alternate = {"Model"})
    @Expose
	@Nullable
    public String model;

    /**
     * The Product Key.
     * Product Key of the Windows autopilot device.
     */
    @SerializedName(value = "productKey", alternate = {"ProductKey"})
    @Expose
	@Nullable
    public String productKey;

    /**
     * The Purchase Order Identifier.
     * Purchase Order Identifier of the Windows autopilot device.
     */
    @SerializedName(value = "purchaseOrderIdentifier", alternate = {"PurchaseOrderIdentifier"})
    @Expose
	@Nullable
    public String purchaseOrderIdentifier;

    /**
     * The Resource Name.
     * Resource Name.
     */
    @SerializedName(value = "resourceName", alternate = {"ResourceName"})
    @Expose
	@Nullable
    public String resourceName;

    /**
     * The Serial Number.
     * Serial number of the Windows autopilot device.
     */
    @SerializedName(value = "serialNumber", alternate = {"SerialNumber"})
    @Expose
	@Nullable
    public String serialNumber;

    /**
     * The Sku Number.
     * SKU Number
     */
    @SerializedName(value = "skuNumber", alternate = {"SkuNumber"})
    @Expose
	@Nullable
    public String skuNumber;

    /**
     * The System Family.
     * System Family
     */
    @SerializedName(value = "systemFamily", alternate = {"SystemFamily"})
    @Expose
	@Nullable
    public String systemFamily;

    /**
     * The User Principal Name.
     * User Principal Name.
     */
    @SerializedName(value = "userPrincipalName", alternate = {"UserPrincipalName"})
    @Expose
	@Nullable
    public String userPrincipalName;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
