// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.PrintTask;
import com.microsoft.graph.requests.PrintTaskDefinitionWithReferenceRequestBuilder;
import com.microsoft.graph.requests.PrintTaskTriggerWithReferenceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Print Task Request.
 */
public class PrintTaskRequest extends BaseRequest<PrintTask> {
	
    /**
     * The request for the PrintTask
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrintTaskRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintTask.class);
    }

    /**
     * Gets the PrintTask from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintTask> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the PrintTask from the service
     *
     * @return the PrintTask from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrintTask get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintTask> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public PrintTask delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this PrintTask with a source
     *
     * @param sourcePrintTask the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintTask> patchAsync(@Nonnull final PrintTask sourcePrintTask) {
        return sendAsync(HttpMethod.PATCH, sourcePrintTask);
    }

    /**
     * Patches this PrintTask with a source
     *
     * @param sourcePrintTask the source object with updates
     * @return the updated PrintTask
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrintTask patch(@Nonnull final PrintTask sourcePrintTask) throws ClientException {
        return send(HttpMethod.PATCH, sourcePrintTask);
    }

    /**
     * Creates a PrintTask with a new object
     *
     * @param newPrintTask the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintTask> postAsync(@Nonnull final PrintTask newPrintTask) {
        return sendAsync(HttpMethod.POST, newPrintTask);
    }

    /**
     * Creates a PrintTask with a new object
     *
     * @param newPrintTask the new object to create
     * @return the created PrintTask
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrintTask post(@Nonnull final PrintTask newPrintTask) throws ClientException {
        return send(HttpMethod.POST, newPrintTask);
    }

    /**
     * Creates a PrintTask with a new object
     *
     * @param newPrintTask the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintTask> putAsync(@Nonnull final PrintTask newPrintTask) {
        return sendAsync(HttpMethod.PUT, newPrintTask);
    }

    /**
     * Creates a PrintTask with a new object
     *
     * @param newPrintTask the object to create/update
     * @return the created PrintTask
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrintTask put(@Nonnull final PrintTask newPrintTask) throws ClientException {
        return send(HttpMethod.PUT, newPrintTask);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public PrintTaskRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public PrintTaskRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

