// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.Initiator;
import com.microsoft.graph.models.ModifiedProperty;
import com.microsoft.graph.models.ProvisioningAction;
import com.microsoft.graph.models.ProvisioningStatusInfo;
import com.microsoft.graph.models.ProvisioningStep;
import com.microsoft.graph.models.ProvisioningServicePrincipal;
import com.microsoft.graph.models.ProvisionedIdentity;
import com.microsoft.graph.models.ProvisioningSystem;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Provisioning Object Summary.
 */
public class ProvisioningObjectSummary extends Entity implements IJsonBackedObject {


    /**
     * The Activity Date Time.
     * The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z
     */
    @SerializedName(value = "activityDateTime", alternate = {"ActivityDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime activityDateTime;

    /**
     * The Change Id.
     * Unique ID of this change in this cycle.
     */
    @SerializedName(value = "changeId", alternate = {"ChangeId"})
    @Expose
	@Nullable
    public String changeId;

    /**
     * The Cycle Id.
     * Unique ID per job iteration.
     */
    @SerializedName(value = "cycleId", alternate = {"CycleId"})
    @Expose
	@Nullable
    public String cycleId;

    /**
     * The Duration In Milliseconds.
     * Indicates how long this provisioning action took to finish. Measured in milliseconds.
     */
    @SerializedName(value = "durationInMilliseconds", alternate = {"DurationInMilliseconds"})
    @Expose
	@Nullable
    public Integer durationInMilliseconds;

    /**
     * The Initiated By.
     * Details of who initiated this provisioning.
     */
    @SerializedName(value = "initiatedBy", alternate = {"InitiatedBy"})
    @Expose
	@Nullable
    public Initiator initiatedBy;

    /**
     * The Job Id.
     * The unique ID for the whole provisioning job.
     */
    @SerializedName(value = "jobId", alternate = {"JobId"})
    @Expose
	@Nullable
    public String jobId;

    /**
     * The Modified Properties.
     * Details of each property that was modified in this provisioning action on this object.
     */
    @SerializedName(value = "modifiedProperties", alternate = {"ModifiedProperties"})
    @Expose
	@Nullable
    public java.util.List<ModifiedProperty> modifiedProperties;

    /**
     * The Provisioning Action.
     * 
     */
    @SerializedName(value = "provisioningAction", alternate = {"ProvisioningAction"})
    @Expose
	@Nullable
    public ProvisioningAction provisioningAction;

    /**
     * The Provisioning Status Info.
     * 
     */
    @SerializedName(value = "provisioningStatusInfo", alternate = {"ProvisioningStatusInfo"})
    @Expose
	@Nullable
    public ProvisioningStatusInfo provisioningStatusInfo;

    /**
     * The Provisioning Steps.
     * Details of each step in provisioning.
     */
    @SerializedName(value = "provisioningSteps", alternate = {"ProvisioningSteps"})
    @Expose
	@Nullable
    public java.util.List<ProvisioningStep> provisioningSteps;

    /**
     * The Service Principal.
     * Represents the service principal used for provisioning.
     */
    @SerializedName(value = "servicePrincipal", alternate = {"ServicePrincipal"})
    @Expose
	@Nullable
    public ProvisioningServicePrincipal servicePrincipal;

    /**
     * The Source Identity.
     * Details of source object being provisioned.
     */
    @SerializedName(value = "sourceIdentity", alternate = {"SourceIdentity"})
    @Expose
	@Nullable
    public ProvisionedIdentity sourceIdentity;

    /**
     * The Source System.
     * Details of source system of the object being provisioned.
     */
    @SerializedName(value = "sourceSystem", alternate = {"SourceSystem"})
    @Expose
	@Nullable
    public ProvisioningSystem sourceSystem;

    /**
     * The Target Identity.
     * Details of target object being provisioned.
     */
    @SerializedName(value = "targetIdentity", alternate = {"TargetIdentity"})
    @Expose
	@Nullable
    public ProvisionedIdentity targetIdentity;

    /**
     * The Target System.
     * Details of target system of the object being provisioned.
     */
    @SerializedName(value = "targetSystem", alternate = {"TargetSystem"})
    @Expose
	@Nullable
    public ProvisioningSystem targetSystem;

    /**
     * The Tenant Id.
     * Unique Azure AD tenant ID.
     */
    @SerializedName(value = "tenantId", alternate = {"TenantId"})
    @Expose
	@Nullable
    public String tenantId;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
