// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.DeviceConfiguration;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Mac OSCustom Configuration.
 */
public class MacOSCustomConfiguration extends DeviceConfiguration implements IJsonBackedObject {


    /**
     * The Payload.
     * Payload. (UTF8 encoded byte array)
     */
    @SerializedName(value = "payload", alternate = {"Payload"})
    @Expose
	@Nullable
    public byte[] payload;

    /**
     * The Payload File Name.
     * Payload file name (.mobileconfig | .xml).
     */
    @SerializedName(value = "payloadFileName", alternate = {"PayloadFileName"})
    @Expose
	@Nullable
    public String payloadFileName;

    /**
     * The Payload Name.
     * Name that is displayed to the user.
     */
    @SerializedName(value = "payloadName", alternate = {"PayloadName"})
    @Expose
	@Nullable
    public String payloadName;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
