// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Fido2AuthenticationMethod;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Fido2Authentication Method Request.
 */
public class Fido2AuthenticationMethodRequest extends BaseRequest<Fido2AuthenticationMethod> {
	
    /**
     * The request for the Fido2AuthenticationMethod
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public Fido2AuthenticationMethodRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Fido2AuthenticationMethod.class);
    }

    /**
     * Gets the Fido2AuthenticationMethod from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Fido2AuthenticationMethod> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Fido2AuthenticationMethod from the service
     *
     * @return the Fido2AuthenticationMethod from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Fido2AuthenticationMethod get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Fido2AuthenticationMethod> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Fido2AuthenticationMethod delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Fido2AuthenticationMethod with a source
     *
     * @param sourceFido2AuthenticationMethod the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Fido2AuthenticationMethod> patchAsync(@Nonnull final Fido2AuthenticationMethod sourceFido2AuthenticationMethod) {
        return sendAsync(HttpMethod.PATCH, sourceFido2AuthenticationMethod);
    }

    /**
     * Patches this Fido2AuthenticationMethod with a source
     *
     * @param sourceFido2AuthenticationMethod the source object with updates
     * @return the updated Fido2AuthenticationMethod
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Fido2AuthenticationMethod patch(@Nonnull final Fido2AuthenticationMethod sourceFido2AuthenticationMethod) throws ClientException {
        return send(HttpMethod.PATCH, sourceFido2AuthenticationMethod);
    }

    /**
     * Creates a Fido2AuthenticationMethod with a new object
     *
     * @param newFido2AuthenticationMethod the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Fido2AuthenticationMethod> postAsync(@Nonnull final Fido2AuthenticationMethod newFido2AuthenticationMethod) {
        return sendAsync(HttpMethod.POST, newFido2AuthenticationMethod);
    }

    /**
     * Creates a Fido2AuthenticationMethod with a new object
     *
     * @param newFido2AuthenticationMethod the new object to create
     * @return the created Fido2AuthenticationMethod
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Fido2AuthenticationMethod post(@Nonnull final Fido2AuthenticationMethod newFido2AuthenticationMethod) throws ClientException {
        return send(HttpMethod.POST, newFido2AuthenticationMethod);
    }

    /**
     * Creates a Fido2AuthenticationMethod with a new object
     *
     * @param newFido2AuthenticationMethod the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Fido2AuthenticationMethod> putAsync(@Nonnull final Fido2AuthenticationMethod newFido2AuthenticationMethod) {
        return sendAsync(HttpMethod.PUT, newFido2AuthenticationMethod);
    }

    /**
     * Creates a Fido2AuthenticationMethod with a new object
     *
     * @param newFido2AuthenticationMethod the object to create/update
     * @return the created Fido2AuthenticationMethod
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Fido2AuthenticationMethod put(@Nonnull final Fido2AuthenticationMethod newFido2AuthenticationMethod) throws ClientException {
        return send(HttpMethod.PUT, newFido2AuthenticationMethod);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public Fido2AuthenticationMethodRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public Fido2AuthenticationMethodRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

