// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.MobileAppInstallTimeSettings;
import com.microsoft.graph.models.Win32LobAppNotification;
import com.microsoft.graph.models.Win32LobAppRestartSettings;
import com.microsoft.graph.models.MobileAppAssignmentSettings;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Win32Lob App Assignment Settings.
 */
public class Win32LobAppAssignmentSettings extends MobileAppAssignmentSettings implements IJsonBackedObject {


    /**
     * The Install Time Settings.
     * The install time settings to apply for this app assignment.
     */
    @SerializedName(value = "installTimeSettings", alternate = {"InstallTimeSettings"})
    @Expose
	@Nullable
    public MobileAppInstallTimeSettings installTimeSettings;

    /**
     * The Notifications.
     * The notification status for this app assignment. Possible values are: showAll, showReboot, hideAll.
     */
    @SerializedName(value = "notifications", alternate = {"Notifications"})
    @Expose
	@Nullable
    public Win32LobAppNotification notifications;

    /**
     * The Restart Settings.
     * The reboot settings to apply for this app assignment.
     */
    @SerializedName(value = "restartSettings", alternate = {"RestartSettings"})
    @Expose
	@Nullable
    public Win32LobAppRestartSettings restartSettings;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
