// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Drive Item Validate Permission Parameter Set.
 */
public class DriveItemValidatePermissionParameterSet {
    /**
     * The challenge Token.
     * 
     */
    @SerializedName(value = "challengeToken", alternate = {"ChallengeToken"})
    @Expose
	@Nullable
    public String challengeToken;

    /**
     * The password.
     * 
     */
    @SerializedName(value = "password", alternate = {"Password"})
    @Expose
	@Nullable
    public String password;


    /**
     * Instiaciates a new DriveItemValidatePermissionParameterSet
     */
    public DriveItemValidatePermissionParameterSet() {}
    /**
     * Instiaciates a new DriveItemValidatePermissionParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected DriveItemValidatePermissionParameterSet(@Nonnull final DriveItemValidatePermissionParameterSetBuilder builder) {
        this.challengeToken = builder.challengeToken;
        this.password = builder.password;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static DriveItemValidatePermissionParameterSetBuilder newBuilder() {
        return new DriveItemValidatePermissionParameterSetBuilder();
    }
    /**
     * Fluent builder for the DriveItemValidatePermissionParameterSet
     */
    public static final class DriveItemValidatePermissionParameterSetBuilder {
        /**
         * The challengeToken parameter value
         */
        @Nullable
        protected String challengeToken;
        /**
         * Sets the ChallengeToken
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public DriveItemValidatePermissionParameterSetBuilder withChallengeToken(@Nullable final String val) {
            this.challengeToken = val;
            return this;
        }
        /**
         * The password parameter value
         */
        @Nullable
        protected String password;
        /**
         * Sets the Password
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public DriveItemValidatePermissionParameterSetBuilder withPassword(@Nullable final String val) {
            this.password = val;
            return this;
        }
        /**
         * Instanciates a new DriveItemValidatePermissionParameterSetBuilder
         */
        @Nullable
        protected DriveItemValidatePermissionParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public DriveItemValidatePermissionParameterSet build() {
            return new DriveItemValidatePermissionParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.challengeToken != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("challengeToken", challengeToken));
        }
        if(this.password != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("password", password));
        }
        return result;
    }
}
