// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Workbook;
import com.microsoft.graph.models.WorkbookSessionInfo;
import com.microsoft.graph.requests.WorkbookApplicationRequestBuilder;
import com.microsoft.graph.requests.WorkbookCommentCollectionRequestBuilder;
import com.microsoft.graph.requests.WorkbookCommentRequestBuilder;
import com.microsoft.graph.requests.WorkbookFunctionsRequestBuilder;
import com.microsoft.graph.requests.WorkbookNamedItemCollectionRequestBuilder;
import com.microsoft.graph.requests.WorkbookNamedItemRequestBuilder;
import com.microsoft.graph.requests.WorkbookOperationCollectionRequestBuilder;
import com.microsoft.graph.requests.WorkbookOperationRequestBuilder;
import com.microsoft.graph.requests.WorkbookTableCollectionRequestBuilder;
import com.microsoft.graph.requests.WorkbookTableRequestBuilder;
import com.microsoft.graph.requests.WorkbookWorksheetCollectionRequestBuilder;
import com.microsoft.graph.requests.WorkbookWorksheetRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.models.WorkbookCreateSessionParameterSet;
import com.microsoft.graph.models.WorkbookSessionInfoResourceParameterSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Request Builder.
 */
public class WorkbookRequestBuilder extends BaseRequestBuilder<Workbook> {

    /**
     * The request builder for the Workbook
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the WorkbookRequest instance
     */
    @Nonnull
    public WorkbookRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the WorkbookRequest instance
     */
    @Nonnull
    public WorkbookRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.WorkbookRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets the request builder for WorkbookApplication
     *
     * @return the WorkbookApplicationRequestBuilder instance
     */
    @Nonnull
    public WorkbookApplicationRequestBuilder application() {
        return new WorkbookApplicationRequestBuilder(getRequestUrlWithAdditionalSegment("application"), getClient(), null);
    }
    /**
     *  Gets a request builder for the WorkbookComment collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public WorkbookCommentCollectionRequestBuilder comments() {
        return new WorkbookCommentCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("comments"), getClient(), null);
    }

    /**
     * Gets a request builder for the WorkbookComment item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public WorkbookCommentRequestBuilder comments(@Nonnull final String id) {
        return new WorkbookCommentRequestBuilder(getRequestUrlWithAdditionalSegment("comments") + "/" + id, getClient(), null);
    }

    /**
     * Gets the request builder for WorkbookFunctions
     *
     * @return the WorkbookFunctionsRequestBuilder instance
     */
    @Nonnull
    public WorkbookFunctionsRequestBuilder functions() {
        return new WorkbookFunctionsRequestBuilder(getRequestUrlWithAdditionalSegment("functions"), getClient(), null);
    }
    /**
     *  Gets a request builder for the WorkbookNamedItem collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public WorkbookNamedItemCollectionRequestBuilder names() {
        return new WorkbookNamedItemCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("names"), getClient(), null);
    }

    /**
     * Gets a request builder for the WorkbookNamedItem item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public WorkbookNamedItemRequestBuilder names(@Nonnull final String id) {
        return new WorkbookNamedItemRequestBuilder(getRequestUrlWithAdditionalSegment("names") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the WorkbookOperation collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public WorkbookOperationCollectionRequestBuilder operations() {
        return new WorkbookOperationCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("operations"), getClient(), null);
    }

    /**
     * Gets a request builder for the WorkbookOperation item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public WorkbookOperationRequestBuilder operations(@Nonnull final String id) {
        return new WorkbookOperationRequestBuilder(getRequestUrlWithAdditionalSegment("operations") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the WorkbookTable collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public WorkbookTableCollectionRequestBuilder tables() {
        return new WorkbookTableCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("tables"), getClient(), null);
    }

    /**
     * Gets a request builder for the WorkbookTable item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public WorkbookTableRequestBuilder tables(@Nonnull final String id) {
        return new WorkbookTableRequestBuilder(getRequestUrlWithAdditionalSegment("tables") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the WorkbookWorksheet collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public WorkbookWorksheetCollectionRequestBuilder worksheets() {
        return new WorkbookWorksheetCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("worksheets"), getClient(), null);
    }

    /**
     * Gets a request builder for the WorkbookWorksheet item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public WorkbookWorksheetRequestBuilder worksheets(@Nonnull final String id) {
        return new WorkbookWorksheetRequestBuilder(getRequestUrlWithAdditionalSegment("worksheets") + "/" + id, getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public WorkbookCloseSessionRequestBuilder closeSession() {
        return new WorkbookCloseSessionRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.closeSession"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public WorkbookCreateSessionRequestBuilder createSession(@Nonnull final WorkbookCreateSessionParameterSet parameters) {
        return new WorkbookCreateSessionRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.createSession"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public WorkbookRefreshSessionRequestBuilder refreshSession() {
        return new WorkbookRefreshSessionRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.refreshSession"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public WorkbookSessionInfoResourceRequestBuilder sessionInfoResource(@Nonnull final WorkbookSessionInfoResourceParameterSet parameters) {
        return new WorkbookSessionInfoResourceRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.sessionInfoResource"), getClient(), null, parameters);
    }
}
