// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.UrlAssessmentRequest;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Url Assessment Request Request.
 */
public class UrlAssessmentRequestRequest extends BaseRequest<UrlAssessmentRequest> {
	
    /**
     * The request for the UrlAssessmentRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UrlAssessmentRequestRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UrlAssessmentRequest.class);
    }

    /**
     * Gets the UrlAssessmentRequest from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UrlAssessmentRequest> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the UrlAssessmentRequest from the service
     *
     * @return the UrlAssessmentRequest from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UrlAssessmentRequest get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UrlAssessmentRequest> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public UrlAssessmentRequest delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this UrlAssessmentRequest with a source
     *
     * @param sourceUrlAssessmentRequest the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UrlAssessmentRequest> patchAsync(@Nonnull final UrlAssessmentRequest sourceUrlAssessmentRequest) {
        return sendAsync(HttpMethod.PATCH, sourceUrlAssessmentRequest);
    }

    /**
     * Patches this UrlAssessmentRequest with a source
     *
     * @param sourceUrlAssessmentRequest the source object with updates
     * @return the updated UrlAssessmentRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UrlAssessmentRequest patch(@Nonnull final UrlAssessmentRequest sourceUrlAssessmentRequest) throws ClientException {
        return send(HttpMethod.PATCH, sourceUrlAssessmentRequest);
    }

    /**
     * Creates a UrlAssessmentRequest with a new object
     *
     * @param newUrlAssessmentRequest the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UrlAssessmentRequest> postAsync(@Nonnull final UrlAssessmentRequest newUrlAssessmentRequest) {
        return sendAsync(HttpMethod.POST, newUrlAssessmentRequest);
    }

    /**
     * Creates a UrlAssessmentRequest with a new object
     *
     * @param newUrlAssessmentRequest the new object to create
     * @return the created UrlAssessmentRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UrlAssessmentRequest post(@Nonnull final UrlAssessmentRequest newUrlAssessmentRequest) throws ClientException {
        return send(HttpMethod.POST, newUrlAssessmentRequest);
    }

    /**
     * Creates a UrlAssessmentRequest with a new object
     *
     * @param newUrlAssessmentRequest the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UrlAssessmentRequest> putAsync(@Nonnull final UrlAssessmentRequest newUrlAssessmentRequest) {
        return sendAsync(HttpMethod.PUT, newUrlAssessmentRequest);
    }

    /**
     * Creates a UrlAssessmentRequest with a new object
     *
     * @param newUrlAssessmentRequest the object to create/update
     * @return the created UrlAssessmentRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UrlAssessmentRequest put(@Nonnull final UrlAssessmentRequest newUrlAssessmentRequest) throws ClientException {
        return send(HttpMethod.PUT, newUrlAssessmentRequest);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public UrlAssessmentRequestRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public UrlAssessmentRequestRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

