// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.EnrollmentTroubleshootingEvent;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Enrollment Troubleshooting Event Request.
 */
public class EnrollmentTroubleshootingEventRequest extends BaseRequest<EnrollmentTroubleshootingEvent> {
	
    /**
     * The request for the EnrollmentTroubleshootingEvent
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EnrollmentTroubleshootingEventRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EnrollmentTroubleshootingEvent.class);
    }

    /**
     * Gets the EnrollmentTroubleshootingEvent from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EnrollmentTroubleshootingEvent> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the EnrollmentTroubleshootingEvent from the service
     *
     * @return the EnrollmentTroubleshootingEvent from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EnrollmentTroubleshootingEvent get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EnrollmentTroubleshootingEvent> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public EnrollmentTroubleshootingEvent delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this EnrollmentTroubleshootingEvent with a source
     *
     * @param sourceEnrollmentTroubleshootingEvent the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EnrollmentTroubleshootingEvent> patchAsync(@Nonnull final EnrollmentTroubleshootingEvent sourceEnrollmentTroubleshootingEvent) {
        return sendAsync(HttpMethod.PATCH, sourceEnrollmentTroubleshootingEvent);
    }

    /**
     * Patches this EnrollmentTroubleshootingEvent with a source
     *
     * @param sourceEnrollmentTroubleshootingEvent the source object with updates
     * @return the updated EnrollmentTroubleshootingEvent
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EnrollmentTroubleshootingEvent patch(@Nonnull final EnrollmentTroubleshootingEvent sourceEnrollmentTroubleshootingEvent) throws ClientException {
        return send(HttpMethod.PATCH, sourceEnrollmentTroubleshootingEvent);
    }

    /**
     * Creates a EnrollmentTroubleshootingEvent with a new object
     *
     * @param newEnrollmentTroubleshootingEvent the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EnrollmentTroubleshootingEvent> postAsync(@Nonnull final EnrollmentTroubleshootingEvent newEnrollmentTroubleshootingEvent) {
        return sendAsync(HttpMethod.POST, newEnrollmentTroubleshootingEvent);
    }

    /**
     * Creates a EnrollmentTroubleshootingEvent with a new object
     *
     * @param newEnrollmentTroubleshootingEvent the new object to create
     * @return the created EnrollmentTroubleshootingEvent
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EnrollmentTroubleshootingEvent post(@Nonnull final EnrollmentTroubleshootingEvent newEnrollmentTroubleshootingEvent) throws ClientException {
        return send(HttpMethod.POST, newEnrollmentTroubleshootingEvent);
    }

    /**
     * Creates a EnrollmentTroubleshootingEvent with a new object
     *
     * @param newEnrollmentTroubleshootingEvent the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EnrollmentTroubleshootingEvent> putAsync(@Nonnull final EnrollmentTroubleshootingEvent newEnrollmentTroubleshootingEvent) {
        return sendAsync(HttpMethod.PUT, newEnrollmentTroubleshootingEvent);
    }

    /**
     * Creates a EnrollmentTroubleshootingEvent with a new object
     *
     * @param newEnrollmentTroubleshootingEvent the object to create/update
     * @return the created EnrollmentTroubleshootingEvent
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EnrollmentTroubleshootingEvent put(@Nonnull final EnrollmentTroubleshootingEvent newEnrollmentTroubleshootingEvent) throws ClientException {
        return send(HttpMethod.PUT, newEnrollmentTroubleshootingEvent);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public EnrollmentTroubleshootingEventRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public EnrollmentTroubleshootingEventRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

