// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ClaimsMappingPolicy;
import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.models.ExtensionProperty;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Claims Mapping Policy Request.
 */
public class ClaimsMappingPolicyRequest extends BaseRequest<ClaimsMappingPolicy> {
	
    /**
     * The request for the ClaimsMappingPolicy
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ClaimsMappingPolicyRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ClaimsMappingPolicy.class);
    }

    /**
     * Gets the ClaimsMappingPolicy from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ClaimsMappingPolicy> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ClaimsMappingPolicy from the service
     *
     * @return the ClaimsMappingPolicy from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ClaimsMappingPolicy get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ClaimsMappingPolicy> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ClaimsMappingPolicy delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ClaimsMappingPolicy with a source
     *
     * @param sourceClaimsMappingPolicy the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ClaimsMappingPolicy> patchAsync(@Nonnull final ClaimsMappingPolicy sourceClaimsMappingPolicy) {
        return sendAsync(HttpMethod.PATCH, sourceClaimsMappingPolicy);
    }

    /**
     * Patches this ClaimsMappingPolicy with a source
     *
     * @param sourceClaimsMappingPolicy the source object with updates
     * @return the updated ClaimsMappingPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ClaimsMappingPolicy patch(@Nonnull final ClaimsMappingPolicy sourceClaimsMappingPolicy) throws ClientException {
        return send(HttpMethod.PATCH, sourceClaimsMappingPolicy);
    }

    /**
     * Creates a ClaimsMappingPolicy with a new object
     *
     * @param newClaimsMappingPolicy the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ClaimsMappingPolicy> postAsync(@Nonnull final ClaimsMappingPolicy newClaimsMappingPolicy) {
        return sendAsync(HttpMethod.POST, newClaimsMappingPolicy);
    }

    /**
     * Creates a ClaimsMappingPolicy with a new object
     *
     * @param newClaimsMappingPolicy the new object to create
     * @return the created ClaimsMappingPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ClaimsMappingPolicy post(@Nonnull final ClaimsMappingPolicy newClaimsMappingPolicy) throws ClientException {
        return send(HttpMethod.POST, newClaimsMappingPolicy);
    }

    /**
     * Creates a ClaimsMappingPolicy with a new object
     *
     * @param newClaimsMappingPolicy the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ClaimsMappingPolicy> putAsync(@Nonnull final ClaimsMappingPolicy newClaimsMappingPolicy) {
        return sendAsync(HttpMethod.PUT, newClaimsMappingPolicy);
    }

    /**
     * Creates a ClaimsMappingPolicy with a new object
     *
     * @param newClaimsMappingPolicy the object to create/update
     * @return the created ClaimsMappingPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ClaimsMappingPolicy put(@Nonnull final ClaimsMappingPolicy newClaimsMappingPolicy) throws ClientException {
        return send(HttpMethod.PUT, newClaimsMappingPolicy);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ClaimsMappingPolicyRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ClaimsMappingPolicyRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

