// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Dollar Parameter Set.
 */
public class WorkbookFunctionsDollarParameterSet {
    /**
     * The number.
     * 
     */
    @SerializedName(value = "number", alternate = {"Number"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement number;

    /**
     * The decimals.
     * 
     */
    @SerializedName(value = "decimals", alternate = {"Decimals"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement decimals;


    /**
     * Instiaciates a new WorkbookFunctionsDollarParameterSet
     */
    public WorkbookFunctionsDollarParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsDollarParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsDollarParameterSet(@Nonnull final WorkbookFunctionsDollarParameterSetBuilder builder) {
        this.number = builder.number;
        this.decimals = builder.decimals;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsDollarParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsDollarParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsDollarParameterSet
     */
    public static final class WorkbookFunctionsDollarParameterSetBuilder {
        /**
         * The number parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement number;
        /**
         * Sets the Number
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsDollarParameterSetBuilder withNumber(@Nullable final com.google.gson.JsonElement val) {
            this.number = val;
            return this;
        }
        /**
         * The decimals parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement decimals;
        /**
         * Sets the Decimals
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsDollarParameterSetBuilder withDecimals(@Nullable final com.google.gson.JsonElement val) {
            this.decimals = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsDollarParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsDollarParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsDollarParameterSet build() {
            return new WorkbookFunctionsDollarParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.number != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("number", number));
        }
        if(this.decimals != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("decimals", decimals));
        }
        return result;
    }
}
