// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.AppListItem;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ios Network Usage Rule.
 */
public class IosNetworkUsageRule implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Cellular Data Blocked.
     * If set to true, corresponding managed apps will not be allowed to use cellular data at any time.
     */
    @SerializedName(value = "cellularDataBlocked", alternate = {"CellularDataBlocked"})
    @Expose
	@Nullable
    public Boolean cellularDataBlocked;

    /**
     * The Cellular Data Block When Roaming.
     * If set to true, corresponding managed apps will not be allowed to use cellular data when roaming.
     */
    @SerializedName(value = "cellularDataBlockWhenRoaming", alternate = {"CellularDataBlockWhenRoaming"})
    @Expose
	@Nullable
    public Boolean cellularDataBlockWhenRoaming;

    /**
     * The Managed Apps.
     * Information about the managed apps that this rule is going to apply to. This collection can contain a maximum of 500 elements.
     */
    @SerializedName(value = "managedApps", alternate = {"ManagedApps"})
    @Expose
	@Nullable
    public java.util.List<AppListItem> managedApps;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
