// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Onenote;
import com.microsoft.graph.requests.NotebookCollectionRequestBuilder;
import com.microsoft.graph.requests.NotebookRequestBuilder;
import com.microsoft.graph.requests.OnenoteOperationCollectionRequestBuilder;
import com.microsoft.graph.requests.OnenoteOperationRequestBuilder;
import com.microsoft.graph.requests.OnenotePageCollectionRequestBuilder;
import com.microsoft.graph.requests.OnenotePageRequestBuilder;
import com.microsoft.graph.requests.OnenoteResourceCollectionRequestBuilder;
import com.microsoft.graph.requests.OnenoteResourceRequestBuilder;
import com.microsoft.graph.requests.SectionGroupCollectionRequestBuilder;
import com.microsoft.graph.requests.SectionGroupRequestBuilder;
import com.microsoft.graph.requests.OnenoteSectionCollectionRequestBuilder;
import com.microsoft.graph.requests.OnenoteSectionRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Onenote Request Builder.
 */
public class OnenoteRequestBuilder extends BaseRequestBuilder<Onenote> {

    /**
     * The request builder for the Onenote
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OnenoteRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the OnenoteRequest instance
     */
    @Nonnull
    public OnenoteRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the OnenoteRequest instance
     */
    @Nonnull
    public OnenoteRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.OnenoteRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the Notebook collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public NotebookCollectionRequestBuilder notebooks() {
        return new NotebookCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("notebooks"), getClient(), null);
    }

    /**
     * Gets a request builder for the Notebook item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public NotebookRequestBuilder notebooks(@Nonnull final String id) {
        return new NotebookRequestBuilder(getRequestUrlWithAdditionalSegment("notebooks") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the OnenoteOperation collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public OnenoteOperationCollectionRequestBuilder operations() {
        return new OnenoteOperationCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("operations"), getClient(), null);
    }

    /**
     * Gets a request builder for the OnenoteOperation item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public OnenoteOperationRequestBuilder operations(@Nonnull final String id) {
        return new OnenoteOperationRequestBuilder(getRequestUrlWithAdditionalSegment("operations") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the OnenotePage collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public OnenotePageCollectionRequestBuilder pages() {
        return new OnenotePageCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("pages"), getClient(), null);
    }

    /**
     * Gets a request builder for the OnenotePage item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public OnenotePageRequestBuilder pages(@Nonnull final String id) {
        return new OnenotePageRequestBuilder(getRequestUrlWithAdditionalSegment("pages") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the OnenoteResource collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public OnenoteResourceCollectionRequestBuilder resources() {
        return new OnenoteResourceCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("resources"), getClient(), null);
    }

    /**
     * Gets a request builder for the OnenoteResource item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public OnenoteResourceRequestBuilder resources(@Nonnull final String id) {
        return new OnenoteResourceRequestBuilder(getRequestUrlWithAdditionalSegment("resources") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the SectionGroup collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public SectionGroupCollectionRequestBuilder sectionGroups() {
        return new SectionGroupCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("sectionGroups"), getClient(), null);
    }

    /**
     * Gets a request builder for the SectionGroup item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public SectionGroupRequestBuilder sectionGroups(@Nonnull final String id) {
        return new SectionGroupRequestBuilder(getRequestUrlWithAdditionalSegment("sectionGroups") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the OnenoteSection collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public OnenoteSectionCollectionRequestBuilder sections() {
        return new OnenoteSectionCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("sections"), getClient(), null);
    }

    /**
     * Gets a request builder for the OnenoteSection item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public OnenoteSectionRequestBuilder sections(@Nonnull final String id) {
        return new OnenoteSectionRequestBuilder(getRequestUrlWithAdditionalSegment("sections") + "/" + id, getClient(), null);
    }
}
