// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.FileHash;
import com.microsoft.graph.models.ProcessIntegrityLevel;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Process.
 */
public class Process implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Account Name.
     * User account identifier (user account context the process ran under) for example, AccountName, SID, and so on.
     */
    @SerializedName(value = "accountName", alternate = {"AccountName"})
    @Expose
	@Nullable
    public String accountName;

    /**
     * The Command Line.
     * The full process invocation commandline including all parameters.
     */
    @SerializedName(value = "commandLine", alternate = {"CommandLine"})
    @Expose
	@Nullable
    public String commandLine;

    /**
     * The Created Date Time.
     * Time at which the process was started. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'.
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime createdDateTime;

    /**
     * The File Hash.
     * Complex type containing file hashes (cryptographic and location-sensitive).
     */
    @SerializedName(value = "fileHash", alternate = {"FileHash"})
    @Expose
	@Nullable
    public FileHash fileHash;

    /**
     * The Integrity Level.
     * The integrity level of the process. Possible values are: unknown, untrusted, low, medium, high, system.
     */
    @SerializedName(value = "integrityLevel", alternate = {"IntegrityLevel"})
    @Expose
	@Nullable
    public ProcessIntegrityLevel integrityLevel;

    /**
     * The Is Elevated.
     * True if the process is elevated.
     */
    @SerializedName(value = "isElevated", alternate = {"IsElevated"})
    @Expose
	@Nullable
    public Boolean isElevated;

    /**
     * The Name.
     * The name of the process' Image file.
     */
    @SerializedName(value = "name", alternate = {"Name"})
    @Expose
	@Nullable
    public String name;

    /**
     * The Parent Process Created Date Time.
     * DateTime at which the parent process was started. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'.
     */
    @SerializedName(value = "parentProcessCreatedDateTime", alternate = {"ParentProcessCreatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime parentProcessCreatedDateTime;

    /**
     * The Parent Process Id.
     * The Process ID (PID) of the parent process.
     */
    @SerializedName(value = "parentProcessId", alternate = {"ParentProcessId"})
    @Expose
	@Nullable
    public Integer parentProcessId;

    /**
     * The Parent Process Name.
     * The name of the image file of the parent process.
     */
    @SerializedName(value = "parentProcessName", alternate = {"ParentProcessName"})
    @Expose
	@Nullable
    public String parentProcessName;

    /**
     * The Path.
     * Full path, including filename.
     */
    @SerializedName(value = "path", alternate = {"Path"})
    @Expose
	@Nullable
    public String path;

    /**
     * The Process Id.
     * The Process ID (PID) of the process.
     */
    @SerializedName(value = "processId", alternate = {"ProcessId"})
    @Expose
	@Nullable
    public Integer processId;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
