// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.PrintConnector;
import com.microsoft.graph.models.PrinterShare;
import com.microsoft.graph.models.PrintTaskTrigger;
import com.microsoft.graph.models.PrinterBase;
import com.microsoft.graph.requests.PrintConnectorCollectionPage;
import com.microsoft.graph.requests.PrinterShareCollectionPage;
import com.microsoft.graph.requests.PrintTaskTriggerCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Printer.
 */
public class Printer extends PrinterBase implements IJsonBackedObject {


    /**
     * The Has Physical Device.
     * True if the printer has a physical device for printing. Read-only.
     */
    @SerializedName(value = "hasPhysicalDevice", alternate = {"HasPhysicalDevice"})
    @Expose
	@Nullable
    public Boolean hasPhysicalDevice;

    /**
     * The Is Shared.
     * True if the printer is shared; false otherwise. Read-only.
     */
    @SerializedName(value = "isShared", alternate = {"IsShared"})
    @Expose
	@Nullable
    public Boolean isShared;

    /**
     * The Registered Date Time.
     * The DateTimeOffset when the printer was registered. Read-only.
     */
    @SerializedName(value = "registeredDateTime", alternate = {"RegisteredDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime registeredDateTime;

    /**
     * The Connectors.
     * The connectors that are associated with the printer.
     */
	@Nullable
    public PrintConnectorCollectionPage connectors;

    /**
     * The Shares.
     * The list of printerShares that are associated with the printer. Currently, only one printerShare can be associated with the printer. Read-only. Nullable.
     */
	@Nullable
    public PrinterShareCollectionPage shares;

    /**
     * The Task Triggers.
     * A list of task triggers that are associated with the printer.
     */
    @SerializedName(value = "taskTriggers", alternate = {"TaskTriggers"})
    @Expose
	@Nullable
    public PrintTaskTriggerCollectionPage taskTriggers;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("connectors")) {
            connectors = serializer.deserializeObject(json.get("connectors"), PrintConnectorCollectionPage.class);
        }

        if (json.has("shares")) {
            shares = serializer.deserializeObject(json.get("shares"), PrinterShareCollectionPage.class);
        }

        if (json.has("taskTriggers")) {
            taskTriggers = serializer.deserializeObject(json.get("taskTriggers"), PrintTaskTriggerCollectionPage.class);
        }
    }
}
