/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.PrintUsageByUser;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPrintUsageByUserCollectionPage;
import com.microsoft.graph.requests.extensions.IPrintUsageByUserCollectionRequest;
import com.microsoft.graph.requests.extensions.PrintUsageByUserCollectionPage;
import com.microsoft.graph.requests.extensions.PrintUsageByUserCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintUsageByUserCollectionResponse;
import com.microsoft.graph.requests.extensions.PrintUsageByUserRequestBuilder;
import java.util.List;

public class PrintUsageByUserCollectionRequest
extends BaseCollectionRequest<PrintUsageByUserCollectionResponse, IPrintUsageByUserCollectionPage>
implements IPrintUsageByUserCollectionRequest {
    public PrintUsageByUserCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintUsageByUserCollectionResponse.class, IPrintUsageByUserCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IPrintUsageByUserCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(PrintUsageByUserCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IPrintUsageByUserCollectionPage get() throws ClientException {
        PrintUsageByUserCollectionResponse response = (PrintUsageByUserCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(PrintUsageByUser newPrintUsageByUser, ICallback<? super PrintUsageByUser> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new PrintUsageByUserRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPrintUsageByUser, callback);
    }

    @Override
    public PrintUsageByUser post(PrintUsageByUser newPrintUsageByUser) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PrintUsageByUserRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPrintUsageByUser);
    }

    @Override
    public IPrintUsageByUserCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IPrintUsageByUserCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IPrintUsageByUserCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IPrintUsageByUserCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPrintUsageByUserCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IPrintUsageByUserCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IPrintUsageByUserCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IPrintUsageByUserCollectionPage buildFromResponse(PrintUsageByUserCollectionResponse response) {
        PrintUsageByUserCollectionRequestBuilder builder = response.nextLink != null ? new PrintUsageByUserCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        PrintUsageByUserCollectionPage page = new PrintUsageByUserCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

