/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.PrintTask;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPrintTaskCollectionPage;
import com.microsoft.graph.requests.extensions.IPrintTaskCollectionRequest;
import com.microsoft.graph.requests.extensions.PrintTaskCollectionPage;
import com.microsoft.graph.requests.extensions.PrintTaskCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintTaskCollectionResponse;
import com.microsoft.graph.requests.extensions.PrintTaskRequestBuilder;
import java.util.List;

public class PrintTaskCollectionRequest
extends BaseCollectionRequest<PrintTaskCollectionResponse, IPrintTaskCollectionPage>
implements IPrintTaskCollectionRequest {
    public PrintTaskCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintTaskCollectionResponse.class, IPrintTaskCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IPrintTaskCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(PrintTaskCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IPrintTaskCollectionPage get() throws ClientException {
        PrintTaskCollectionResponse response = (PrintTaskCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(PrintTask newPrintTask, ICallback<? super PrintTask> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new PrintTaskRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPrintTask, callback);
    }

    @Override
    public PrintTask post(PrintTask newPrintTask) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PrintTaskRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPrintTask);
    }

    @Override
    public IPrintTaskCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IPrintTaskCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IPrintTaskCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IPrintTaskCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPrintTaskCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IPrintTaskCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IPrintTaskCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IPrintTaskCollectionPage buildFromResponse(PrintTaskCollectionResponse response) {
        PrintTaskCollectionRequestBuilder builder = response.nextLink != null ? new PrintTaskCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        PrintTaskCollectionPage page = new PrintTaskCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

