/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DeviceComplianceActionItem;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DeviceComplianceActionItemCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceComplianceActionItemCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DeviceComplianceActionItemCollectionResponse;
import com.microsoft.graph.requests.extensions.DeviceComplianceActionItemRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceComplianceActionItemCollectionPage;
import com.microsoft.graph.requests.extensions.IDeviceComplianceActionItemCollectionRequest;
import java.util.List;

public class DeviceComplianceActionItemCollectionRequest
extends BaseCollectionRequest<DeviceComplianceActionItemCollectionResponse, IDeviceComplianceActionItemCollectionPage>
implements IDeviceComplianceActionItemCollectionRequest {
    public DeviceComplianceActionItemCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceComplianceActionItemCollectionResponse.class, IDeviceComplianceActionItemCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IDeviceComplianceActionItemCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DeviceComplianceActionItemCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceComplianceActionItemCollectionPage get() throws ClientException {
        DeviceComplianceActionItemCollectionResponse response = (DeviceComplianceActionItemCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DeviceComplianceActionItem newDeviceComplianceActionItem, ICallback<? super DeviceComplianceActionItem> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DeviceComplianceActionItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDeviceComplianceActionItem, callback);
    }

    @Override
    public DeviceComplianceActionItem post(DeviceComplianceActionItem newDeviceComplianceActionItem) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DeviceComplianceActionItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDeviceComplianceActionItem);
    }

    @Override
    public IDeviceComplianceActionItemCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IDeviceComplianceActionItemCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IDeviceComplianceActionItemCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IDeviceComplianceActionItemCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDeviceComplianceActionItemCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IDeviceComplianceActionItemCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IDeviceComplianceActionItemCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IDeviceComplianceActionItemCollectionPage buildFromResponse(DeviceComplianceActionItemCollectionResponse response) {
        DeviceComplianceActionItemCollectionRequestBuilder builder = response.nextLink != null ? new DeviceComplianceActionItemCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceComplianceActionItemCollectionPage page = new DeviceComplianceActionItemCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

