/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ConditionalAccessPolicy;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ConditionalAccessPolicyCollectionPage;
import com.microsoft.graph.requests.extensions.ConditionalAccessPolicyCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ConditionalAccessPolicyCollectionResponse;
import com.microsoft.graph.requests.extensions.ConditionalAccessPolicyRequestBuilder;
import com.microsoft.graph.requests.extensions.IConditionalAccessPolicyCollectionPage;
import com.microsoft.graph.requests.extensions.IConditionalAccessPolicyCollectionRequest;
import java.util.List;

public class ConditionalAccessPolicyCollectionRequest
extends BaseCollectionRequest<ConditionalAccessPolicyCollectionResponse, IConditionalAccessPolicyCollectionPage>
implements IConditionalAccessPolicyCollectionRequest {
    public ConditionalAccessPolicyCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ConditionalAccessPolicyCollectionResponse.class, IConditionalAccessPolicyCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IConditionalAccessPolicyCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ConditionalAccessPolicyCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IConditionalAccessPolicyCollectionPage get() throws ClientException {
        ConditionalAccessPolicyCollectionResponse response = (ConditionalAccessPolicyCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ConditionalAccessPolicy newConditionalAccessPolicy, ICallback<? super ConditionalAccessPolicy> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ConditionalAccessPolicyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newConditionalAccessPolicy, callback);
    }

    @Override
    public ConditionalAccessPolicy post(ConditionalAccessPolicy newConditionalAccessPolicy) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ConditionalAccessPolicyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newConditionalAccessPolicy);
    }

    @Override
    public IConditionalAccessPolicyCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IConditionalAccessPolicyCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IConditionalAccessPolicyCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IConditionalAccessPolicyCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IConditionalAccessPolicyCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IConditionalAccessPolicyCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IConditionalAccessPolicyCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IConditionalAccessPolicyCollectionPage buildFromResponse(ConditionalAccessPolicyCollectionResponse response) {
        ConditionalAccessPolicyCollectionRequestBuilder builder = response.nextLink != null ? new ConditionalAccessPolicyCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ConditionalAccessPolicyCollectionPage page = new ConditionalAccessPolicyCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

