/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.Authentication;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IAuthenticationRequest;
import java.util.List;

public class AuthenticationRequest
extends BaseRequest
implements IAuthenticationRequest {
    public AuthenticationRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Authentication.class);
    }

    @Override
    public void get(ICallback<? super Authentication> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Authentication get() throws ClientException {
        return (Authentication)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super Authentication> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Authentication sourceAuthentication, ICallback<? super Authentication> callback) {
        this.send(HttpMethod.PATCH, callback, sourceAuthentication);
    }

    @Override
    public Authentication patch(Authentication sourceAuthentication) throws ClientException {
        return (Authentication)this.send(HttpMethod.PATCH, sourceAuthentication);
    }

    @Override
    public void post(Authentication newAuthentication, ICallback<? super Authentication> callback) {
        this.send(HttpMethod.POST, callback, newAuthentication);
    }

    @Override
    public Authentication post(Authentication newAuthentication) throws ClientException {
        return (Authentication)this.send(HttpMethod.POST, newAuthentication);
    }

    @Override
    public void put(Authentication newAuthentication, ICallback<? super Authentication> callback) {
        this.send(HttpMethod.PUT, callback, newAuthentication);
    }

    @Override
    public Authentication put(Authentication newAuthentication) throws ClientException {
        return (Authentication)this.send(HttpMethod.PUT, newAuthentication);
    }

    @Override
    public IAuthenticationRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IAuthenticationRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

