/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.http;

import com.google.common.base.CaseFormat;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.graph.core.GraphErrorCodes;
import com.microsoft.graph.http.GraphInnerError;

public class GraphError {
    @SerializedName(value="message")
    @Expose
    public String message;
    @SerializedName(value="code")
    @Expose
    public String code;
    @SerializedName(value="innererror")
    public GraphInnerError innererror;

    public boolean isError(GraphErrorCodes expectedCode) {
        if (this.transformErrorCodeCase(this.code).equalsIgnoreCase(expectedCode.toString())) {
            return true;
        }
        GraphInnerError innerError = this.innererror;
        while (null != innerError) {
            if (this.transformErrorCodeCase(innerError.code).equalsIgnoreCase(expectedCode.toString())) {
                return true;
            }
            innerError = innerError.innererror;
        }
        return false;
    }

    protected String transformErrorCodeCase(String original) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, original);
    }
}

