/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DirectoryObjectGetMemberGroupsBody;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DirectoryObjectGetMemberGroupsCollectionPage;
import com.microsoft.graph.requests.extensions.DirectoryObjectGetMemberGroupsCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DirectoryObjectGetMemberGroupsCollectionResponse;
import com.microsoft.graph.requests.extensions.IDirectoryObjectGetMemberGroupsCollectionPage;
import com.microsoft.graph.requests.extensions.IDirectoryObjectGetMemberGroupsCollectionRequest;
import java.util.List;

public class DirectoryObjectGetMemberGroupsCollectionRequest
extends BaseCollectionRequest<DirectoryObjectGetMemberGroupsCollectionResponse, IDirectoryObjectGetMemberGroupsCollectionPage>
implements IDirectoryObjectGetMemberGroupsCollectionRequest {
    protected final DirectoryObjectGetMemberGroupsBody body = new DirectoryObjectGetMemberGroupsBody();

    public DirectoryObjectGetMemberGroupsCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DirectoryObjectGetMemberGroupsCollectionResponse.class, IDirectoryObjectGetMemberGroupsCollectionPage.class);
    }

    @Override
    public void post(final ICallback<? super IDirectoryObjectGetMemberGroupsCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DirectoryObjectGetMemberGroupsCollectionRequest.this.post(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDirectoryObjectGetMemberGroupsCollectionPage post() throws ClientException {
        DirectoryObjectGetMemberGroupsCollectionResponse response = (DirectoryObjectGetMemberGroupsCollectionResponse)this.post(this.body);
        return this.buildFromResponse(response);
    }

    public IDirectoryObjectGetMemberGroupsCollectionPage buildFromResponse(DirectoryObjectGetMemberGroupsCollectionResponse response) {
        DirectoryObjectGetMemberGroupsCollectionRequestBuilder builder = response.nextLink != null ? new DirectoryObjectGetMemberGroupsCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null, null) : null;
        DirectoryObjectGetMemberGroupsCollectionPage page = new DirectoryObjectGetMemberGroupsCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IDirectoryObjectGetMemberGroupsCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDirectoryObjectGetMemberGroupsCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IDirectoryObjectGetMemberGroupsCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IDirectoryObjectGetMemberGroupsCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public IDirectoryObjectGetMemberGroupsCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }
}

