// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IManagedDeviceBypassActivationLockRequest;
import com.microsoft.graph.requests.extensions.ManagedDeviceBypassActivationLockRequest;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Managed Device Bypass Activation Lock Request Builder.
 */
public class ManagedDeviceBypassActivationLockRequestBuilder extends BaseActionRequestBuilder implements IManagedDeviceBypassActivationLockRequestBuilder {

    /**
     * The request builder for this ManagedDeviceBypassActivationLock
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ManagedDeviceBypassActivationLockRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the IManagedDeviceBypassActivationLockRequest
     *
     * @param requestOptions the options for the request
     * @return the IManagedDeviceBypassActivationLockRequest instance
     */
    public IManagedDeviceBypassActivationLockRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the IManagedDeviceBypassActivationLockRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IManagedDeviceBypassActivationLockRequest instance
     */
    public IManagedDeviceBypassActivationLockRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        ManagedDeviceBypassActivationLockRequest request = new ManagedDeviceBypassActivationLockRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        return request;
    }
}
