// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.ConditionalAccessRoot;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Conditional Access Root Request.
 */
public interface IConditionalAccessRootRequest extends IHttpRequest {

    /**
     * Gets the ConditionalAccessRoot from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super ConditionalAccessRoot> callback);

    /**
     * Gets the ConditionalAccessRoot from the service
     *
     * @return the ConditionalAccessRoot from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ConditionalAccessRoot get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super ConditionalAccessRoot> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this ConditionalAccessRoot with a source
     *
     * @param sourceConditionalAccessRoot the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final ConditionalAccessRoot sourceConditionalAccessRoot, final ICallback<? super ConditionalAccessRoot> callback);

    /**
     * Patches this ConditionalAccessRoot with a source
     *
     * @param sourceConditionalAccessRoot the source object with updates
     * @return the updated ConditionalAccessRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ConditionalAccessRoot patch(final ConditionalAccessRoot sourceConditionalAccessRoot) throws ClientException;

    /**
     * Posts a ConditionalAccessRoot with a new object
     *
     * @param newConditionalAccessRoot the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final ConditionalAccessRoot newConditionalAccessRoot, final ICallback<? super ConditionalAccessRoot> callback);

    /**
     * Posts a ConditionalAccessRoot with a new object
     *
     * @param newConditionalAccessRoot the new object to create
     * @return the created ConditionalAccessRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ConditionalAccessRoot post(final ConditionalAccessRoot newConditionalAccessRoot) throws ClientException;

    /**
     * Posts a ConditionalAccessRoot with a new object
     *
     * @param newConditionalAccessRoot the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final ConditionalAccessRoot newConditionalAccessRoot, final ICallback<? super ConditionalAccessRoot> callback);

    /**
     * Posts a ConditionalAccessRoot with a new object
     *
     * @param newConditionalAccessRoot the object to create/update
     * @return the created ConditionalAccessRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ConditionalAccessRoot put(final ConditionalAccessRoot newConditionalAccessRoot) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IConditionalAccessRootRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IConditionalAccessRootRequest expand(final String value);

}

