// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.AuthorizationPolicy;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Authorization Policy Request.
 */
public class AuthorizationPolicyRequest extends BaseRequest implements IAuthorizationPolicyRequest {
	
    /**
     * The request for the AuthorizationPolicy
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AuthorizationPolicyRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AuthorizationPolicy.class);
    }

    /**
     * Gets the AuthorizationPolicy from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super AuthorizationPolicy> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the AuthorizationPolicy from the service
     *
     * @return the AuthorizationPolicy from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public AuthorizationPolicy get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super AuthorizationPolicy> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AuthorizationPolicy with a source
     *
     * @param sourceAuthorizationPolicy the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final AuthorizationPolicy sourceAuthorizationPolicy, final ICallback<? super AuthorizationPolicy> callback) {
        send(HttpMethod.PATCH, callback, sourceAuthorizationPolicy);
    }

    /**
     * Patches this AuthorizationPolicy with a source
     *
     * @param sourceAuthorizationPolicy the source object with updates
     * @return the updated AuthorizationPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public AuthorizationPolicy patch(final AuthorizationPolicy sourceAuthorizationPolicy) throws ClientException {
        return send(HttpMethod.PATCH, sourceAuthorizationPolicy);
    }

    /**
     * Creates a AuthorizationPolicy with a new object
     *
     * @param newAuthorizationPolicy the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final AuthorizationPolicy newAuthorizationPolicy, final ICallback<? super AuthorizationPolicy> callback) {
        send(HttpMethod.POST, callback, newAuthorizationPolicy);
    }

    /**
     * Creates a AuthorizationPolicy with a new object
     *
     * @param newAuthorizationPolicy the new object to create
     * @return the created AuthorizationPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public AuthorizationPolicy post(final AuthorizationPolicy newAuthorizationPolicy) throws ClientException {
        return send(HttpMethod.POST, newAuthorizationPolicy);
    }

    /**
     * Creates a AuthorizationPolicy with a new object
     *
     * @param newAuthorizationPolicy the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final AuthorizationPolicy newAuthorizationPolicy, final ICallback<? super AuthorizationPolicy> callback) {
        send(HttpMethod.PUT, callback, newAuthorizationPolicy);
    }

    /**
     * Creates a AuthorizationPolicy with a new object
     *
     * @param newAuthorizationPolicy the object to create/update
     * @return the created AuthorizationPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public AuthorizationPolicy put(final AuthorizationPolicy newAuthorizationPolicy) throws ClientException {
        return send(HttpMethod.PUT, newAuthorizationPolicy);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IAuthorizationPolicyRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (AuthorizationPolicyRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IAuthorizationPolicyRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (AuthorizationPolicyRequest)this;
     }

}

