// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the On Premises Conditional Access Settings.
 */
public class OnPremisesConditionalAccessSettings extends Entity implements IJsonBackedObject {


    /**
     * The Enabled.
     * Indicates if on premises conditional access is enabled for this organization
     */
    @SerializedName(value = "enabled", alternate = {"Enabled"})
    @Expose
    public Boolean enabled;

    /**
     * The Excluded Groups.
     * User groups that will be exempt by on premises conditional access. All users in these groups will be exempt from the conditional access policy.
     */
    @SerializedName(value = "excludedGroups", alternate = {"ExcludedGroups"})
    @Expose
    public java.util.List<java.util.UUID> excludedGroups;

    /**
     * The Included Groups.
     * User groups that will be targeted by on premises conditional access. All users in these groups will be required to have mobile device managed and compliant for mail access.
     */
    @SerializedName(value = "includedGroups", alternate = {"IncludedGroups"})
    @Expose
    public java.util.List<java.util.UUID> includedGroups;

    /**
     * The Override Default Rule.
     * Override the default access rule when allowing a device to ensure access is granted.
     */
    @SerializedName(value = "overrideDefaultRule", alternate = {"OverrideDefaultRule"})
    @Expose
    public Boolean overrideDefaultRule;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
