/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.Post;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPostCollectionPage;
import com.microsoft.graph.requests.extensions.IPostCollectionRequest;
import com.microsoft.graph.requests.extensions.PostCollectionPage;
import com.microsoft.graph.requests.extensions.PostCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PostCollectionResponse;
import com.microsoft.graph.requests.extensions.PostRequestBuilder;
import java.util.List;

public class PostCollectionRequest
extends BaseCollectionRequest<PostCollectionResponse, IPostCollectionPage>
implements IPostCollectionRequest {
    public PostCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PostCollectionResponse.class, IPostCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IPostCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(PostCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IPostCollectionPage get() throws ClientException {
        PostCollectionResponse response = (PostCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Post newPost, ICallback<? super Post> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new PostRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPost, callback);
    }

    @Override
    public Post post(Post newPost) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PostRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPost);
    }

    @Override
    public IPostCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IPostCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IPostCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IPostCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPostCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IPostCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IPostCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IPostCollectionPage buildFromResponse(PostCollectionResponse response) {
        PostCollectionRequestBuilder builder = response.nextLink != null ? new PostCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        PostCollectionPage page = new PostCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

