// Template Source: IBaseMethodRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.WorkbookRangeView;
import com.microsoft.graph.requests.extensions.IWorkbookRangeVisibleViewRequest;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Workbook Range Visible View Request.
 */
public interface IWorkbookRangeVisibleViewRequest extends IHttpRequest {

    /**
     * Patches the WorkbookRangeVisibleView
     *
     * @param srcWorkbookRangeView the WorkbookRangeView with which to PATCH
     * @param callback the callback to be called after success or failure
     */
    void patch(WorkbookRangeView srcWorkbookRangeView, final ICallback<? super WorkbookRangeView> callback);

    /**
     * Patches the WorkbookRangeVisibleView
     *
     * @param srcWorkbookRangeView the WorkbookRangeView with which to PATCH
     * @return the WorkbookRangeView
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    WorkbookRangeView patch(WorkbookRangeView srcWorkbookRangeView) throws ClientException;

    /**
     * Puts the WorkbookRangeVisibleView
     *
     * @param srcWorkbookRangeView the WorkbookRangeView to PUT
     * @param callback the callback to be called after success or failure
     */
    void put(WorkbookRangeView srcWorkbookRangeView, final ICallback<? super WorkbookRangeView> callback);

    /**
     * Puts the WorkbookRangeVisibleView
     *
     * @param srcWorkbookRangeView the WorkbookRangeView to PUT
     * @return the WorkbookRangeView
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
     WorkbookRangeView put(WorkbookRangeView srcWorkbookRangeView) throws ClientException;
    /**
     * Gets the WorkbookRangeView
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super WorkbookRangeView> callback);

    /**
     * Gets the WorkbookRangeView
     *
     * @return the WorkbookRangeView
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    WorkbookRangeView get() throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IWorkbookRangeVisibleViewRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IWorkbookRangeVisibleViewRequest expand(final String value);

}
