// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.TodoTask;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Todo Task Request.
 */
public interface ITodoTaskRequest extends IHttpRequest {

    /**
     * Gets the TodoTask from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super TodoTask> callback);

    /**
     * Gets the TodoTask from the service
     *
     * @return the TodoTask from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TodoTask get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super TodoTask> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this TodoTask with a source
     *
     * @param sourceTodoTask the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final TodoTask sourceTodoTask, final ICallback<? super TodoTask> callback);

    /**
     * Patches this TodoTask with a source
     *
     * @param sourceTodoTask the source object with updates
     * @return the updated TodoTask
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TodoTask patch(final TodoTask sourceTodoTask) throws ClientException;

    /**
     * Posts a TodoTask with a new object
     *
     * @param newTodoTask the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final TodoTask newTodoTask, final ICallback<? super TodoTask> callback);

    /**
     * Posts a TodoTask with a new object
     *
     * @param newTodoTask the new object to create
     * @return the created TodoTask
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TodoTask post(final TodoTask newTodoTask) throws ClientException;

    /**
     * Posts a TodoTask with a new object
     *
     * @param newTodoTask the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final TodoTask newTodoTask, final ICallback<? super TodoTask> callback);

    /**
     * Posts a TodoTask with a new object
     *
     * @param newTodoTask the object to create/update
     * @return the created TodoTask
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TodoTask put(final TodoTask newTodoTask) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    ITodoTaskRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    ITodoTaskRequest expand(final String value);

}

