// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.ScheduleChangeRequest;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Schedule Change Request Request.
 */
public interface IScheduleChangeRequestRequest extends IHttpRequest {

    /**
     * Gets the ScheduleChangeRequest from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super ScheduleChangeRequest> callback);

    /**
     * Gets the ScheduleChangeRequest from the service
     *
     * @return the ScheduleChangeRequest from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ScheduleChangeRequest get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super ScheduleChangeRequest> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this ScheduleChangeRequest with a source
     *
     * @param sourceScheduleChangeRequest the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final ScheduleChangeRequest sourceScheduleChangeRequest, final ICallback<? super ScheduleChangeRequest> callback);

    /**
     * Patches this ScheduleChangeRequest with a source
     *
     * @param sourceScheduleChangeRequest the source object with updates
     * @return the updated ScheduleChangeRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ScheduleChangeRequest patch(final ScheduleChangeRequest sourceScheduleChangeRequest) throws ClientException;

    /**
     * Posts a ScheduleChangeRequest with a new object
     *
     * @param newScheduleChangeRequest the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final ScheduleChangeRequest newScheduleChangeRequest, final ICallback<? super ScheduleChangeRequest> callback);

    /**
     * Posts a ScheduleChangeRequest with a new object
     *
     * @param newScheduleChangeRequest the new object to create
     * @return the created ScheduleChangeRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ScheduleChangeRequest post(final ScheduleChangeRequest newScheduleChangeRequest) throws ClientException;

    /**
     * Posts a ScheduleChangeRequest with a new object
     *
     * @param newScheduleChangeRequest the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final ScheduleChangeRequest newScheduleChangeRequest, final ICallback<? super ScheduleChangeRequest> callback);

    /**
     * Posts a ScheduleChangeRequest with a new object
     *
     * @param newScheduleChangeRequest the object to create/update
     * @return the created ScheduleChangeRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ScheduleChangeRequest put(final ScheduleChangeRequest newScheduleChangeRequest) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IScheduleChangeRequestRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IScheduleChangeRequestRequest expand(final String value);

}

