// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.Recipient;
import com.microsoft.graph.models.generated.Importance;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Message Rule Actions.
 */
public class MessageRuleActions implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Assign Categories.
     * A list of categories to be assigned to a message.
     */
    @SerializedName(value = "assignCategories", alternate = {"AssignCategories"})
    @Expose
    public java.util.List<String> assignCategories;

    /**
     * The Copy To Folder.
     * The ID of a folder that a message is to be copied to.
     */
    @SerializedName(value = "copyToFolder", alternate = {"CopyToFolder"})
    @Expose
    public String copyToFolder;

    /**
     * The Delete.
     * Indicates whether a message should be moved to the Deleted Items folder.
     */
    @SerializedName(value = "delete", alternate = {"Delete"})
    @Expose
    public Boolean delete;

    /**
     * The Forward As Attachment To.
     * The email addresses of the recipients to which a message should be forwarded as an attachment.
     */
    @SerializedName(value = "forwardAsAttachmentTo", alternate = {"ForwardAsAttachmentTo"})
    @Expose
    public java.util.List<Recipient> forwardAsAttachmentTo;

    /**
     * The Forward To.
     * The email addresses of the recipients to which a message should be forwarded.
     */
    @SerializedName(value = "forwardTo", alternate = {"ForwardTo"})
    @Expose
    public java.util.List<Recipient> forwardTo;

    /**
     * The Mark As Read.
     * Indicates whether a message should be marked as read.
     */
    @SerializedName(value = "markAsRead", alternate = {"MarkAsRead"})
    @Expose
    public Boolean markAsRead;

    /**
     * The Mark Importance.
     * Sets the importance of the message, which can be: low, normal, high.
     */
    @SerializedName(value = "markImportance", alternate = {"MarkImportance"})
    @Expose
    public Importance markImportance;

    /**
     * The Move To Folder.
     * The ID of the folder that a message will be moved to.
     */
    @SerializedName(value = "moveToFolder", alternate = {"MoveToFolder"})
    @Expose
    public String moveToFolder;

    /**
     * The Permanent Delete.
     * Indicates whether a message should be permanently deleted and not saved to the Deleted Items folder.
     */
    @SerializedName(value = "permanentDelete", alternate = {"PermanentDelete"})
    @Expose
    public Boolean permanentDelete;

    /**
     * The Redirect To.
     * The email address to which a message should be redirected.
     */
    @SerializedName(value = "redirectTo", alternate = {"RedirectTo"})
    @Expose
    public java.util.List<Recipient> redirectTo;

    /**
     * The Stop Processing Rules.
     * Indicates whether subsequent rules should be evaluated.
     */
    @SerializedName(value = "stopProcessingRules", alternate = {"StopProcessingRules"})
    @Expose
    public Boolean stopProcessingRules;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
