/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.ServicePrincipal;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IServicePrincipalRequest;
import java.util.List;

public class ServicePrincipalRequest
extends BaseRequest
implements IServicePrincipalRequest {
    public ServicePrincipalRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ServicePrincipal.class);
    }

    @Override
    public void get(ICallback<? super ServicePrincipal> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public ServicePrincipal get() throws ClientException {
        return (ServicePrincipal)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super ServicePrincipal> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(ServicePrincipal sourceServicePrincipal, ICallback<? super ServicePrincipal> callback) {
        this.send(HttpMethod.PATCH, callback, sourceServicePrincipal);
    }

    @Override
    public ServicePrincipal patch(ServicePrincipal sourceServicePrincipal) throws ClientException {
        return (ServicePrincipal)this.send(HttpMethod.PATCH, sourceServicePrincipal);
    }

    @Override
    public void post(ServicePrincipal newServicePrincipal, ICallback<? super ServicePrincipal> callback) {
        this.send(HttpMethod.POST, callback, newServicePrincipal);
    }

    @Override
    public ServicePrincipal post(ServicePrincipal newServicePrincipal) throws ClientException {
        return (ServicePrincipal)this.send(HttpMethod.POST, newServicePrincipal);
    }

    @Override
    public void put(ServicePrincipal newServicePrincipal, ICallback<? super ServicePrincipal> callback) {
        this.send(HttpMethod.PUT, callback, newServicePrincipal);
    }

    @Override
    public ServicePrincipal put(ServicePrincipal newServicePrincipal) throws ClientException {
        return (ServicePrincipal)this.send(HttpMethod.PUT, newServicePrincipal);
    }

    @Override
    public IServicePrincipalRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IServicePrincipalRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

