/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.OutlookCategory;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IOutlookCategoryCollectionPage;
import com.microsoft.graph.requests.extensions.IOutlookCategoryCollectionRequest;
import com.microsoft.graph.requests.extensions.OutlookCategoryCollectionPage;
import com.microsoft.graph.requests.extensions.OutlookCategoryCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.OutlookCategoryCollectionResponse;
import com.microsoft.graph.requests.extensions.OutlookCategoryRequestBuilder;
import java.util.List;

public class OutlookCategoryCollectionRequest
extends BaseCollectionRequest<OutlookCategoryCollectionResponse, IOutlookCategoryCollectionPage>
implements IOutlookCategoryCollectionRequest {
    public OutlookCategoryCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, OutlookCategoryCollectionResponse.class, IOutlookCategoryCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IOutlookCategoryCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(OutlookCategoryCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IOutlookCategoryCollectionPage get() throws ClientException {
        OutlookCategoryCollectionResponse response = (OutlookCategoryCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(OutlookCategory newOutlookCategory, ICallback<? super OutlookCategory> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new OutlookCategoryRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newOutlookCategory, callback);
    }

    @Override
    public OutlookCategory post(OutlookCategory newOutlookCategory) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new OutlookCategoryRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newOutlookCategory);
    }

    @Override
    public IOutlookCategoryCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IOutlookCategoryCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IOutlookCategoryCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IOutlookCategoryCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IOutlookCategoryCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IOutlookCategoryCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IOutlookCategoryCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IOutlookCategoryCollectionPage buildFromResponse(OutlookCategoryCollectionResponse response) {
        OutlookCategoryCollectionRequestBuilder builder = response.nextLink != null ? new OutlookCategoryCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        OutlookCategoryCollectionPage page = new OutlookCategoryCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

