/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ManagedDeviceMobileAppConfigurationAssignment;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IManagedDeviceMobileAppConfigurationAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.IManagedDeviceMobileAppConfigurationAssignmentCollectionRequest;
import com.microsoft.graph.requests.extensions.ManagedDeviceMobileAppConfigurationAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.ManagedDeviceMobileAppConfigurationAssignmentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ManagedDeviceMobileAppConfigurationAssignmentCollectionResponse;
import com.microsoft.graph.requests.extensions.ManagedDeviceMobileAppConfigurationAssignmentRequestBuilder;
import java.util.List;

public class ManagedDeviceMobileAppConfigurationAssignmentCollectionRequest
extends BaseCollectionRequest<ManagedDeviceMobileAppConfigurationAssignmentCollectionResponse, IManagedDeviceMobileAppConfigurationAssignmentCollectionPage>
implements IManagedDeviceMobileAppConfigurationAssignmentCollectionRequest {
    public ManagedDeviceMobileAppConfigurationAssignmentCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ManagedDeviceMobileAppConfigurationAssignmentCollectionResponse.class, IManagedDeviceMobileAppConfigurationAssignmentCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IManagedDeviceMobileAppConfigurationAssignmentCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ManagedDeviceMobileAppConfigurationAssignmentCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IManagedDeviceMobileAppConfigurationAssignmentCollectionPage get() throws ClientException {
        ManagedDeviceMobileAppConfigurationAssignmentCollectionResponse response = (ManagedDeviceMobileAppConfigurationAssignmentCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ManagedDeviceMobileAppConfigurationAssignment newManagedDeviceMobileAppConfigurationAssignment, ICallback<? super ManagedDeviceMobileAppConfigurationAssignment> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ManagedDeviceMobileAppConfigurationAssignmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newManagedDeviceMobileAppConfigurationAssignment, callback);
    }

    @Override
    public ManagedDeviceMobileAppConfigurationAssignment post(ManagedDeviceMobileAppConfigurationAssignment newManagedDeviceMobileAppConfigurationAssignment) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ManagedDeviceMobileAppConfigurationAssignmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newManagedDeviceMobileAppConfigurationAssignment);
    }

    @Override
    public IManagedDeviceMobileAppConfigurationAssignmentCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IManagedDeviceMobileAppConfigurationAssignmentCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IManagedDeviceMobileAppConfigurationAssignmentCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IManagedDeviceMobileAppConfigurationAssignmentCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IManagedDeviceMobileAppConfigurationAssignmentCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IManagedDeviceMobileAppConfigurationAssignmentCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IManagedDeviceMobileAppConfigurationAssignmentCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IManagedDeviceMobileAppConfigurationAssignmentCollectionPage buildFromResponse(ManagedDeviceMobileAppConfigurationAssignmentCollectionResponse response) {
        ManagedDeviceMobileAppConfigurationAssignmentCollectionRequestBuilder builder = response.nextLink != null ? new ManagedDeviceMobileAppConfigurationAssignmentCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ManagedDeviceMobileAppConfigurationAssignmentCollectionPage page = new ManagedDeviceMobileAppConfigurationAssignmentCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

