// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IWorkbookFunctionsRandBetweenRequest;
import com.microsoft.graph.requests.extensions.WorkbookFunctionsRandBetweenRequest;
import com.microsoft.graph.models.extensions.WorkbookFunctionResult;
import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Rand Between Request Builder.
 */
public class WorkbookFunctionsRandBetweenRequestBuilder extends BaseActionRequestBuilder implements IWorkbookFunctionsRandBetweenRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsRandBetween
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param bottom the bottom
     * @param top the top
     */
    public WorkbookFunctionsRandBetweenRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, final com.google.gson.JsonElement bottom, final com.google.gson.JsonElement top) {
        super(requestUrl, client, requestOptions);
        bodyParams.put("bottom", bottom);
        bodyParams.put("top", top);
    }

    /**
     * Creates the IWorkbookFunctionsRandBetweenRequest
     *
     * @param requestOptions the options for the request
     * @return the IWorkbookFunctionsRandBetweenRequest instance
     */
    public IWorkbookFunctionsRandBetweenRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the IWorkbookFunctionsRandBetweenRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IWorkbookFunctionsRandBetweenRequest instance
     */
    public IWorkbookFunctionsRandBetweenRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        WorkbookFunctionsRandBetweenRequest request = new WorkbookFunctionsRandBetweenRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("bottom")) {
            request.body.bottom = getParameter("bottom");
        }

        if (hasParameter("top")) {
            request.body.top = getParameter("top");
        }

        return request;
    }
}
