// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.ItemAttachment;
import com.microsoft.graph.requests.extensions.IOutlookItemRequestBuilder;
import com.microsoft.graph.requests.extensions.OutlookItemRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Item Attachment Request.
 */
public class ItemAttachmentRequest extends BaseRequest implements IItemAttachmentRequest {
	
    /**
     * The request for the ItemAttachment
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ItemAttachmentRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ItemAttachment.class);
    }

    /**
     * Gets the ItemAttachment from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super ItemAttachment> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the ItemAttachment from the service
     *
     * @return the ItemAttachment from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public ItemAttachment get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super ItemAttachment> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ItemAttachment with a source
     *
     * @param sourceItemAttachment the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final ItemAttachment sourceItemAttachment, final ICallback<? super ItemAttachment> callback) {
        send(HttpMethod.PATCH, callback, sourceItemAttachment);
    }

    /**
     * Patches this ItemAttachment with a source
     *
     * @param sourceItemAttachment the source object with updates
     * @return the updated ItemAttachment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public ItemAttachment patch(final ItemAttachment sourceItemAttachment) throws ClientException {
        return send(HttpMethod.PATCH, sourceItemAttachment);
    }

    /**
     * Creates a ItemAttachment with a new object
     *
     * @param newItemAttachment the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final ItemAttachment newItemAttachment, final ICallback<? super ItemAttachment> callback) {
        send(HttpMethod.POST, callback, newItemAttachment);
    }

    /**
     * Creates a ItemAttachment with a new object
     *
     * @param newItemAttachment the new object to create
     * @return the created ItemAttachment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public ItemAttachment post(final ItemAttachment newItemAttachment) throws ClientException {
        return send(HttpMethod.POST, newItemAttachment);
    }

    /**
     * Creates a ItemAttachment with a new object
     *
     * @param newItemAttachment the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final ItemAttachment newItemAttachment, final ICallback<? super ItemAttachment> callback) {
        send(HttpMethod.PUT, callback, newItemAttachment);
    }

    /**
     * Creates a ItemAttachment with a new object
     *
     * @param newItemAttachment the object to create/update
     * @return the created ItemAttachment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public ItemAttachment put(final ItemAttachment newItemAttachment) throws ClientException {
        return send(HttpMethod.PUT, newItemAttachment);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IItemAttachmentRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (ItemAttachmentRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IItemAttachmentRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (ItemAttachmentRequest)this;
     }

}

