// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.DeviceConfigurationAssignment;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Device Configuration Assignment Request.
 */
public interface IDeviceConfigurationAssignmentRequest extends IHttpRequest {

    /**
     * Gets the DeviceConfigurationAssignment from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super DeviceConfigurationAssignment> callback);

    /**
     * Gets the DeviceConfigurationAssignment from the service
     *
     * @return the DeviceConfigurationAssignment from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceConfigurationAssignment get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super DeviceConfigurationAssignment> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this DeviceConfigurationAssignment with a source
     *
     * @param sourceDeviceConfigurationAssignment the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final DeviceConfigurationAssignment sourceDeviceConfigurationAssignment, final ICallback<? super DeviceConfigurationAssignment> callback);

    /**
     * Patches this DeviceConfigurationAssignment with a source
     *
     * @param sourceDeviceConfigurationAssignment the source object with updates
     * @return the updated DeviceConfigurationAssignment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceConfigurationAssignment patch(final DeviceConfigurationAssignment sourceDeviceConfigurationAssignment) throws ClientException;

    /**
     * Posts a DeviceConfigurationAssignment with a new object
     *
     * @param newDeviceConfigurationAssignment the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final DeviceConfigurationAssignment newDeviceConfigurationAssignment, final ICallback<? super DeviceConfigurationAssignment> callback);

    /**
     * Posts a DeviceConfigurationAssignment with a new object
     *
     * @param newDeviceConfigurationAssignment the new object to create
     * @return the created DeviceConfigurationAssignment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceConfigurationAssignment post(final DeviceConfigurationAssignment newDeviceConfigurationAssignment) throws ClientException;

    /**
     * Posts a DeviceConfigurationAssignment with a new object
     *
     * @param newDeviceConfigurationAssignment the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final DeviceConfigurationAssignment newDeviceConfigurationAssignment, final ICallback<? super DeviceConfigurationAssignment> callback);

    /**
     * Posts a DeviceConfigurationAssignment with a new object
     *
     * @param newDeviceConfigurationAssignment the object to create/update
     * @return the created DeviceConfigurationAssignment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceConfigurationAssignment put(final DeviceConfigurationAssignment newDeviceConfigurationAssignment) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IDeviceConfigurationAssignmentRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IDeviceConfigurationAssignmentRequest expand(final String value);

}

