/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.User;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IUserCollectionPage;
import com.microsoft.graph.requests.extensions.IUserCollectionRequest;
import com.microsoft.graph.requests.extensions.UserCollectionPage;
import com.microsoft.graph.requests.extensions.UserCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.UserCollectionResponse;
import com.microsoft.graph.requests.extensions.UserRequestBuilder;
import java.util.List;

public class UserCollectionRequest
extends BaseCollectionRequest<UserCollectionResponse, IUserCollectionPage>
implements IUserCollectionRequest {
    public UserCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserCollectionResponse.class, IUserCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IUserCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(UserCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IUserCollectionPage get() throws ClientException {
        UserCollectionResponse response = (UserCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(User newUser, ICallback<? super User> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new UserRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newUser, callback);
    }

    @Override
    public User post(User newUser) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new UserRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newUser);
    }

    @Override
    public IUserCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IUserCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IUserCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IUserCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IUserCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IUserCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IUserCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IUserCollectionPage buildFromResponse(UserCollectionResponse response) {
        UserCollectionRequestBuilder builder = response.nextLink != null ? new UserCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        UserCollectionPage page = new UserCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

