/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.callrecords.requests.extensions;

import com.microsoft.graph.callrecords.models.extensions.Session;
import com.microsoft.graph.callrecords.requests.extensions.ISessionRequest;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class SessionRequest
extends BaseRequest
implements ISessionRequest {
    public SessionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Session.class);
    }

    @Override
    public void get(ICallback<? super Session> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Session get() throws ClientException {
        return (Session)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super Session> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Session sourceSession, ICallback<? super Session> callback) {
        this.send(HttpMethod.PATCH, callback, sourceSession);
    }

    @Override
    public Session patch(Session sourceSession) throws ClientException {
        return (Session)this.send(HttpMethod.PATCH, sourceSession);
    }

    @Override
    public void post(Session newSession, ICallback<? super Session> callback) {
        this.send(HttpMethod.POST, callback, newSession);
    }

    @Override
    public Session post(Session newSession) throws ClientException {
        return (Session)this.send(HttpMethod.POST, newSession);
    }

    @Override
    public void put(Session newSession, ICallback<? super Session> callback) {
        this.send(HttpMethod.PUT, callback, newSession);
    }

    @Override
    public Session put(Session newSession) throws ClientException {
        return (Session)this.send(HttpMethod.PUT, newSession);
    }

    @Override
    public ISessionRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISessionRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

