// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.OfferShiftRequest;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Offer Shift Request Request.
 */
public class OfferShiftRequestRequest extends BaseRequest implements IOfferShiftRequestRequest {
	
    /**
     * The request for the OfferShiftRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public OfferShiftRequestRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            final Class<? extends OfferShiftRequest> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the OfferShiftRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OfferShiftRequestRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, OfferShiftRequest.class);
    }

    /**
     * Gets the OfferShiftRequest from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super OfferShiftRequest> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the OfferShiftRequest from the service
     *
     * @return the OfferShiftRequest from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public OfferShiftRequest get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super OfferShiftRequest> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this OfferShiftRequest with a source
     *
     * @param sourceOfferShiftRequest the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final OfferShiftRequest sourceOfferShiftRequest, final ICallback<? super OfferShiftRequest> callback) {
        send(HttpMethod.PATCH, callback, sourceOfferShiftRequest);
    }

    /**
     * Patches this OfferShiftRequest with a source
     *
     * @param sourceOfferShiftRequest the source object with updates
     * @return the updated OfferShiftRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public OfferShiftRequest patch(final OfferShiftRequest sourceOfferShiftRequest) throws ClientException {
        return send(HttpMethod.PATCH, sourceOfferShiftRequest);
    }

    /**
     * Creates a OfferShiftRequest with a new object
     *
     * @param newOfferShiftRequest the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final OfferShiftRequest newOfferShiftRequest, final ICallback<? super OfferShiftRequest> callback) {
        send(HttpMethod.POST, callback, newOfferShiftRequest);
    }

    /**
     * Creates a OfferShiftRequest with a new object
     *
     * @param newOfferShiftRequest the new object to create
     * @return the created OfferShiftRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public OfferShiftRequest post(final OfferShiftRequest newOfferShiftRequest) throws ClientException {
        return send(HttpMethod.POST, newOfferShiftRequest);
    }

    /**
     * Creates a OfferShiftRequest with a new object
     *
     * @param newOfferShiftRequest the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final OfferShiftRequest newOfferShiftRequest, final ICallback<? super OfferShiftRequest> callback) {
        send(HttpMethod.PUT, callback, newOfferShiftRequest);
    }

    /**
     * Creates a OfferShiftRequest with a new object
     *
     * @param newOfferShiftRequest the object to create/update
     * @return the created OfferShiftRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public OfferShiftRequest put(final OfferShiftRequest newOfferShiftRequest) throws ClientException {
        return send(HttpMethod.PUT, newOfferShiftRequest);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IOfferShiftRequestRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (OfferShiftRequestRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IOfferShiftRequestRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (OfferShiftRequestRequest)this;
     }

}

