// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.DomainDnsUnavailableRecord;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Domain Dns Unavailable Record Request.
 */
public class DomainDnsUnavailableRecordRequest extends BaseRequest implements IDomainDnsUnavailableRecordRequest {
	
    /**
     * The request for the DomainDnsUnavailableRecord
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DomainDnsUnavailableRecordRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DomainDnsUnavailableRecord.class);
    }

    /**
     * Gets the DomainDnsUnavailableRecord from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super DomainDnsUnavailableRecord> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the DomainDnsUnavailableRecord from the service
     *
     * @return the DomainDnsUnavailableRecord from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public DomainDnsUnavailableRecord get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super DomainDnsUnavailableRecord> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this DomainDnsUnavailableRecord with a source
     *
     * @param sourceDomainDnsUnavailableRecord the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final DomainDnsUnavailableRecord sourceDomainDnsUnavailableRecord, final ICallback<? super DomainDnsUnavailableRecord> callback) {
        send(HttpMethod.PATCH, callback, sourceDomainDnsUnavailableRecord);
    }

    /**
     * Patches this DomainDnsUnavailableRecord with a source
     *
     * @param sourceDomainDnsUnavailableRecord the source object with updates
     * @return the updated DomainDnsUnavailableRecord
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public DomainDnsUnavailableRecord patch(final DomainDnsUnavailableRecord sourceDomainDnsUnavailableRecord) throws ClientException {
        return send(HttpMethod.PATCH, sourceDomainDnsUnavailableRecord);
    }

    /**
     * Creates a DomainDnsUnavailableRecord with a new object
     *
     * @param newDomainDnsUnavailableRecord the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final DomainDnsUnavailableRecord newDomainDnsUnavailableRecord, final ICallback<? super DomainDnsUnavailableRecord> callback) {
        send(HttpMethod.POST, callback, newDomainDnsUnavailableRecord);
    }

    /**
     * Creates a DomainDnsUnavailableRecord with a new object
     *
     * @param newDomainDnsUnavailableRecord the new object to create
     * @return the created DomainDnsUnavailableRecord
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public DomainDnsUnavailableRecord post(final DomainDnsUnavailableRecord newDomainDnsUnavailableRecord) throws ClientException {
        return send(HttpMethod.POST, newDomainDnsUnavailableRecord);
    }

    /**
     * Creates a DomainDnsUnavailableRecord with a new object
     *
     * @param newDomainDnsUnavailableRecord the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final DomainDnsUnavailableRecord newDomainDnsUnavailableRecord, final ICallback<? super DomainDnsUnavailableRecord> callback) {
        send(HttpMethod.PUT, callback, newDomainDnsUnavailableRecord);
    }

    /**
     * Creates a DomainDnsUnavailableRecord with a new object
     *
     * @param newDomainDnsUnavailableRecord the object to create/update
     * @return the created DomainDnsUnavailableRecord
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public DomainDnsUnavailableRecord put(final DomainDnsUnavailableRecord newDomainDnsUnavailableRecord) throws ClientException {
        return send(HttpMethod.PUT, newDomainDnsUnavailableRecord);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IDomainDnsUnavailableRecordRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (DomainDnsUnavailableRecordRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IDomainDnsUnavailableRecordRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (DomainDnsUnavailableRecordRequest)this;
     }

}

