// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.IdentitySet;
import com.microsoft.graph.models.extensions.NotebookLinks;
import com.microsoft.graph.models.generated.OnenoteUserRole;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Copy Notebook Model.
 */
public class CopyNotebookModel implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Created By.
     * 
     */
    @SerializedName(value = "createdBy", alternate = {"CreatedBy"})
    @Expose
    public String createdBy;

    /**
     * The Created By Identity.
     * 
     */
    @SerializedName(value = "createdByIdentity", alternate = {"CreatedByIdentity"})
    @Expose
    public IdentitySet createdByIdentity;

    /**
     * The Created Time.
     * 
     */
    @SerializedName(value = "createdTime", alternate = {"CreatedTime"})
    @Expose
    public java.util.Calendar createdTime;

    /**
     * The Id.
     * 
     */
    @SerializedName(value = "id", alternate = {"Id"})
    @Expose
    public String id;

    /**
     * The Is Default.
     * 
     */
    @SerializedName(value = "isDefault", alternate = {"IsDefault"})
    @Expose
    public Boolean isDefault;

    /**
     * The Is Shared.
     * 
     */
    @SerializedName(value = "isShared", alternate = {"IsShared"})
    @Expose
    public Boolean isShared;

    /**
     * The Last Modified By.
     * 
     */
    @SerializedName(value = "lastModifiedBy", alternate = {"LastModifiedBy"})
    @Expose
    public String lastModifiedBy;

    /**
     * The Last Modified By Identity.
     * 
     */
    @SerializedName(value = "lastModifiedByIdentity", alternate = {"LastModifiedByIdentity"})
    @Expose
    public IdentitySet lastModifiedByIdentity;

    /**
     * The Last Modified Time.
     * 
     */
    @SerializedName(value = "lastModifiedTime", alternate = {"LastModifiedTime"})
    @Expose
    public java.util.Calendar lastModifiedTime;

    /**
     * The Links.
     * 
     */
    @SerializedName(value = "links", alternate = {"Links"})
    @Expose
    public NotebookLinks links;

    /**
     * The Name.
     * 
     */
    @SerializedName(value = "name", alternate = {"Name"})
    @Expose
    public String name;

    /**
     * The Section Groups Url.
     * 
     */
    @SerializedName(value = "sectionGroupsUrl", alternate = {"SectionGroupsUrl"})
    @Expose
    public String sectionGroupsUrl;

    /**
     * The Sections Url.
     * 
     */
    @SerializedName(value = "sectionsUrl", alternate = {"SectionsUrl"})
    @Expose
    public String sectionsUrl;

    /**
     * The Self.
     * 
     */
    @SerializedName(value = "self", alternate = {"Self"})
    @Expose
    public String self;

    /**
     * The User Role.
     * 
     */
    @SerializedName(value = "userRole", alternate = {"UserRole"})
    @Expose
    public OnenoteUserRole userRole;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
